/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor.core.command;

import org.drools.eclipse.flow.common.editor.core.ElementConnection;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.drools.eclipse.flow.common.editor.core.ProcessWrapper;
import org.eclipse.gef.commands.Command;

public class SplitConnectionCommand
extends Command {
    private ProcessWrapper parent;
    private ElementWrapper oldSource;
    private ElementWrapper oldTarget;
    private ElementConnection oldConnection;
    private ElementConnection secondConnection;
    private ElementWrapper newElement;

    public void setNewSecondConnection(ElementConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("new second connection cannot be null");
        }
        this.secondConnection = connection;
    }

    public void execute() {
        if (this.secondConnection == null) {
            throw new IllegalStateException("new second connection is still null");
        }
        this.oldConnection.disconnect();
        this.parent.addElement(this.newElement);
        this.newElement.setParent(this.parent);
        this.oldConnection.connect(this.oldSource, this.newElement);
        this.secondConnection.connect(this.newElement, this.oldTarget);
    }

    public void setParent(ProcessWrapper process) {
        if (process == null) {
            throw new IllegalArgumentException("process is null");
        }
        this.parent = process;
    }

    public void setElementConnection(ElementConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("Element connection is null");
        }
        this.oldConnection = connection;
        this.oldSource = connection.getSource();
        this.oldTarget = connection.getTarget();
    }

    public void setNewElement(ElementWrapper newElement) {
        if (newElement == null) {
            throw new IllegalArgumentException("NewElement is null");
        }
        this.newElement = newElement;
    }

    public void undo() {
        this.oldConnection.disconnect();
        this.secondConnection.disconnect();
        this.parent.removeElement(this.newElement);
        this.newElement.setParent(null);
        this.oldConnection.connect(this.oldSource, this.oldTarget);
    }
}

