/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.view.actions.server;

import com.eclipsesource.json.JsonObject;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.kie.eclipse.navigator.view.actions.KieNavigatorAction;
import org.kie.eclipse.navigator.view.actions.dialogs.CreateOrganizationRequestDialog;
import org.kie.eclipse.navigator.view.content.IContainerNode;
import org.kie.eclipse.server.IKieOrganizationHandler;
import org.kie.eclipse.server.IKieServerHandler;
import org.kie.eclipse.server.IKieServiceDelegate;
import org.kie.eclipse.server.KieOrganizationHandler;

public class CreateOrganizationAction
extends KieNavigatorAction {
    protected CreateOrganizationAction(ISelectionProvider provider, String text) {
        super(provider, text);
    }

    public CreateOrganizationAction(ISelectionProvider selectionProvider) {
        this(selectionProvider, "Create Organization...");
    }

    public void run() {
        IContainerNode<?> container = this.getContainer();
        if (container == null) {
            return;
        }
        IKieServerHandler server = (IKieServerHandler)container.getHandler();
        IKieServiceDelegate delegate = this.getDelegate();
        CreateOrganizationRequestDialog dlg = new CreateOrganizationRequestDialog(CreateOrganizationAction.getShell(), server);
        if (dlg.open() == 0) {
            JsonObject properties = dlg.getResult();
            String name = properties.get("name").asString();
            KieOrganizationHandler organization = new KieOrganizationHandler(server, name);
            organization.setProperties(properties);
            try {
                delegate.createOrganization((IKieOrganizationHandler)organization);
                CreateOrganizationAction.refreshViewer(container);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }
}

