/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.view.datatype.editor.impl;

import java.lang.reflect.InvocationTargetException;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.flow.common.datatype.DataTypeRegistry;
import org.drools.eclipse.flow.common.view.datatype.editor.Editor;
import org.drools.eclipse.flow.common.view.datatype.editor.impl.EmptyEditor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.jbpm.process.core.datatype.DataType;

public class EditorComposite
extends Composite {
    private DataTypeRegistry registry;
    private Editor editor;

    public EditorComposite(Composite parent, int style, DataTypeRegistry registry) {
        super(parent, style);
        this.registry = registry;
        this.setLayout((Layout)new FillLayout());
        this.editor = new EmptyEditor(this);
    }

    public void setDataType(DataType type) {
        ((Composite)this.editor).dispose();
        if (type == null) {
            this.editor = new EmptyEditor(this);
        } else {
            Class<?> editorClass = null;
            try {
                editorClass = this.registry.getDataTypeInfo(type.getClass()).getValueEditorClass();
                this.editor = (Editor)editorClass.getConstructor(Composite.class).newInstance(new Object[]{this});
            }
            catch (IllegalArgumentException e) {
                DroolsEclipsePlugin.log(e);
                this.editor = new EmptyEditor(this);
            }
            catch (InstantiationException e) {
                DroolsEclipsePlugin.log(e);
                this.editor = new EmptyEditor(this);
            }
            catch (NoSuchMethodException e) {
                DroolsEclipsePlugin.log(e);
                this.editor = new EmptyEditor(this);
            }
            catch (InvocationTargetException e) {
                DroolsEclipsePlugin.log(e);
                this.editor = new EmptyEditor(this);
            }
            catch (IllegalAccessException e) {
                DroolsEclipsePlugin.log(e);
                this.editor = new EmptyEditor(this);
            }
            this.editor.setDataType(type);
            this.layout();
        }
    }

    public void setValue(Object value) {
        this.editor.setValue(value);
    }

    public Object getValue() {
        return this.editor.getValue();
    }

    public void reset() {
        this.editor.reset();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        ((Composite)this.editor).setEnabled(enabled);
    }
}

