/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.client;

import java.net.MalformedURLException;
import org.eclipse.webdav.IContext;
import org.eclipse.webdav.ILocator;
import org.eclipse.webdav.IServer;
import org.eclipse.webdav.client.WebDAVFactory;
import org.eclipse.webdav.internal.kernel.utils.Assert;

public abstract class DAVClient
implements IServer {
    protected WebDAVFactory davFactory = null;

    public DAVClient(DAVClient davClient) {
        this.davFactory = davClient.davFactory;
    }

    public DAVClient(WebDAVFactory davFactory) {
        Assert.isNotNull(davFactory);
        this.davFactory = davFactory;
    }

    protected abstract Object clone();

    public WebDAVFactory getDAVFactory() {
        return this.davFactory;
    }

    protected IContext newContext(IContext userContext, ILocator locator) throws MalformedURLException {
        Assert.isNotNull(userContext);
        Assert.isNotNull(locator);
        IContext context = this.davFactory.newContext(userContext);
        if (locator.getLabel() != null) {
            context.setLabel(locator.getLabel());
        }
        return context;
    }

    public void close() {
    }
}

