/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.view.property.action;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.drools.eclipse.editors.DRLSourceViewerConfig;
import org.drools.eclipse.editors.scanners.DRLPartionScanner;
import org.drools.eclipse.flow.common.view.property.EditBeanDialog;
import org.drools.eclipse.flow.ruleflow.view.property.action.ActionCompletionProcessor;
import org.drools.eclipse.flow.ruleflow.view.property.constraint.RuleFlowGlobalsDialog;
import org.drools.eclipse.flow.ruleflow.view.property.constraint.RuleFlowImportsDialog;
import org.drools.eclipse.util.ArrayUtils;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.WorkflowProcess;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;

public class ActionDialog
extends EditBeanDialog<DroolsAction> {
    private static final String[] DIALECTS = new String[]{"mvel", "java"};
    private WorkflowProcess process;
    private TabFolder tabFolder;
    private SourceViewer actionViewer;
    private Combo dialectCombo;
    private ActionCompletionProcessor completionProcessor;

    public ActionDialog(Shell parentShell, WorkflowProcess process) {
        super(parentShell, "Action editor");
        this.process = process;
    }

    @Override
    protected DroolsAction updateValue(DroolsAction action) {
        if (this.tabFolder.getSelectionIndex() == 0) {
            DroolsConsequenceAction result = new DroolsConsequenceAction();
            result.setDialect(this.dialectCombo.getItem(this.dialectCombo.getSelectionIndex()));
            result.setConsequence(this.actionViewer.getDocument().get());
            return result;
        }
        return null;
    }

    @Override
    protected Point getInitialSize() {
        return new Point(600, 450);
    }

    private Control createTextualEditor(Composite parent) {
        this.actionViewer = new SourceViewer(parent, null, 2048);
        this.actionViewer.configure((SourceViewerConfiguration)new DRLSourceViewerConfig(null){

            @Override
            public IReconciler getReconciler(ISourceViewer sourceViewer) {
                return null;
            }

            @Override
            public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
                ContentAssistant assistant = new ContentAssistant();
                ActionDialog.this.completionProcessor = new ActionCompletionProcessor(ActionDialog.this.process);
                assistant.setContentAssistProcessor((IContentAssistProcessor)ActionDialog.this.completionProcessor, "__dftl_partition_content_type");
                assistant.setProposalPopupOrientation(10);
                return assistant;
            }
        });
        this.completionProcessor.setDialect(this.dialectCombo.getItem(this.dialectCombo.getSelectionIndex()));
        Object action = this.getValue();
        String value = null;
        if (action instanceof DroolsConsequenceAction) {
            value = ((DroolsConsequenceAction)action).getConsequence();
        }
        if (value == null) {
            value = "";
        }
        Document document = new Document(value);
        this.actionViewer.setDocument((IDocument)document);
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new DRLPartionScanner(), DRLPartionScanner.LEGAL_CONTENT_TYPES);
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        this.actionViewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == ' ' && e.stateMask == 262144) {
                    ActionDialog.this.actionViewer.doOperation(13);
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        return this.actionViewer.getControl();
    }

    private Control createDialectCombo(Composite parent) {
        String dialect;
        int found;
        this.dialectCombo = new Combo(parent, 12);
        this.dialectCombo.setItems(DIALECTS);
        Object action = this.getValue();
        int index = 0;
        if (action instanceof DroolsConsequenceAction && (found = ArrayUtils.indexOf(DIALECTS, dialect = ((DroolsConsequenceAction)action).getDialect())) >= 0) {
            index = found;
        }
        this.dialectCombo.select(index);
        this.dialectCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ActionDialog.this.completionProcessor.setDialect(ActionDialog.this.dialectCombo.getItem(ActionDialog.this.dialectCombo.getSelectionIndex()));
            }

            public void widgetSelected(SelectionEvent e) {
                ActionDialog.this.completionProcessor.setDialect(ActionDialog.this.dialectCombo.getItem(ActionDialog.this.dialectCombo.getSelectionIndex()));
            }
        });
        return this.dialectCombo;
    }

    public Control createDialogArea(Composite parent) {
        GridLayout layout = new GridLayout();
        parent.setLayout((Layout)layout);
        layout.numColumns = 2;
        Composite top = new Composite(parent, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        top.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 4;
        top.setLayout((Layout)layout);
        Label label = new Label(top, 0);
        label.setText("Dialect:");
        this.createDialectCombo(top);
        Button importButton = new Button(top, 8);
        importButton.setText("Imports ...");
        importButton.setFont(JFaceResources.getDialogFont());
        importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ActionDialog.this.importButtonPressed();
            }
        });
        Button globalButton = new Button(top, 8);
        globalButton.setText("Globals ...");
        globalButton.setFont(JFaceResources.getDialogFont());
        globalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ActionDialog.this.globalButtonPressed();
            }
        });
        this.tabFolder = new TabFolder(parent, 0);
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        this.tabFolder.setLayoutData((Object)gd);
        TabItem textEditorTab = new TabItem(this.tabFolder, 0);
        textEditorTab.setText("Textual Editor");
        textEditorTab.setControl(this.createTextualEditor((Composite)this.tabFolder));
        return this.tabFolder;
    }

    private void importButtonPressed() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                RuleFlowImportsDialog dialog = new RuleFlowImportsDialog(ActionDialog.this.getShell(), ActionDialog.this.process);
                dialog.create();
                int code = dialog.open();
                if (code != 1) {
                    List<String> imports = dialog.getImports();
                    ActionDialog.this.process.setImports(new HashSet<String>(imports));
                    List<String> functionImports = dialog.getFunctionImports();
                    ActionDialog.this.process.setFunctionImports(functionImports);
                    ActionDialog.this.completionProcessor.reset();
                }
            }
        };
        r.run();
    }

    private void globalButtonPressed() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                RuleFlowGlobalsDialog dialog = new RuleFlowGlobalsDialog(ActionDialog.this.getShell(), ActionDialog.this.process);
                dialog.create();
                int code = dialog.open();
                if (code != 1) {
                    Map<String, String> globals = dialog.getGlobals();
                    ActionDialog.this.process.setGlobals(globals);
                    ActionDialog.this.completionProcessor.reset();
                }
            }
        };
        r.run();
    }
}

