/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.Assert;
import org.eclipse.webdav.dom.MalformedElementException;
import org.eclipse.webdav.dom.Namespaces;
import org.eclipse.webdav.dom.QualifiedName;
import org.eclipse.webdav.dom.QualifiedNameImpl;
import org.eclipse.webdav.internal.utils.URLDecoder;
import org.eclipse.webdav.internal.utils.URLEncoder;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public abstract class ElementEditor {
    protected Element root;
    protected static final String DAV_NS = "DAV:";
    protected static final String XML_PREFIX = "xmlns";
    protected static final String XML_NS_PREFIX = "xml";
    protected static final String XML_NS_NAME = "http://www.w3.org/XML/1998/namespace";

    protected ElementEditor(Element root) throws MalformedElementException {
        Assert.isNotNull(root);
        this.root = root;
    }

    protected ElementEditor(Element root, String expectedType) throws MalformedElementException {
        Assert.isNotNull(root);
        Assert.isNotNull(expectedType);
        this.root = root;
        ElementEditor.ensureDAVElement(root, expectedType, Policy.bind("ensure.expectingAnElmt", expectedType));
    }

    public static Element addChild(Element parent, String name, String[] names, boolean firstToLast) {
        Assert.isTrue(ElementEditor.isDAVElement(parent));
        Assert.isNotNull(name);
        Assert.isNotNull(names);
        String nsPrefix = ElementEditor.getNSPrefix(parent);
        String tagName = nsPrefix == null ? name : String.valueOf(nsPrefix) + ":" + name;
        Element child = parent.getOwnerDocument().createElement(tagName);
        ElementEditor.addChild(parent, child, names, firstToLast);
        return child;
    }

    public static Element addChild(Element parent, String name, String data, String[] names, boolean firstToLast) {
        Assert.isTrue(ElementEditor.isDAVElement(parent));
        Assert.isNotNull(name);
        Assert.isNotNull(data);
        Assert.isNotNull(names);
        Element child = ElementEditor.addChild(parent, name, names, firstToLast);
        child.appendChild(child.getOwnerDocument().createTextNode(data));
        return child;
    }

    public static void addChild(Element parent, Element child, String[] names, boolean firstToLast) {
        Assert.isTrue(ElementEditor.isDAVElement(parent));
        Assert.isNotNull(child);
        Assert.isTrue(DAV_NS.equals(ElementEditor.resolve(ElementEditor.getNSPrefix(child), parent)));
        Assert.isNotNull(names);
        boolean found = false;
        String name = ElementEditor.getNSLocalName(child);
        int i = 0;
        while (!found && i < names.length) {
            found = names[i].equals(name);
            ++i;
        }
        Assert.isTrue(found);
        Element sibling = ElementEditor.getChild(parent, name, names, firstToLast);
        if (firstToLast) {
            if (sibling == null) {
                parent.appendChild(child);
            } else {
                Element lastTwin = null;
                while (ElementEditor.isDAVElement(sibling, name)) {
                    lastTwin = sibling;
                    sibling = ElementEditor.getTwin(sibling, firstToLast);
                }
                if (lastTwin == null) {
                    parent.insertBefore(child, sibling);
                } else {
                    Node refChild = lastTwin.getNextSibling();
                    if (refChild == null) {
                        parent.appendChild(child);
                    } else {
                        parent.insertBefore(child, refChild);
                    }
                }
            }
        } else {
            Node refChild = null;
            refChild = sibling == null ? parent.getFirstChild() : sibling.getNextSibling();
            if (refChild == null) {
                parent.appendChild(child);
            } else {
                parent.insertBefore(child, refChild);
            }
        }
    }

    public static Element appendChild(Element parent, String name) {
        Assert.isTrue(ElementEditor.isDAVElement(parent));
        Assert.isNotNull(name);
        String nsPrefix = ElementEditor.getNSPrefix(parent);
        String tagName = nsPrefix == null ? name : String.valueOf(nsPrefix) + ":" + name;
        Element child = parent.getOwnerDocument().createElement(tagName);
        parent.appendChild(child);
        return child;
    }

    public static Element appendChild(Element parent, String name, String data) {
        Assert.isTrue(ElementEditor.isDAVElement(parent));
        Assert.isNotNull(name);
        Assert.isNotNull(data);
        Element child = ElementEditor.appendChild(parent, name);
        child.appendChild(child.getOwnerDocument().createTextNode(data));
        return child;
    }

    public static Node cloneNode(Document document, Node node) {
        Node nodeClone = null;
        switch (node.getNodeType()) {
            case 1: {
                nodeClone = document.createElement(((Element)node).getTagName());
                NamedNodeMap namedNodeMap = node.getAttributes();
                int i = 0;
                while (i < namedNodeMap.getLength()) {
                    Attr attr = (Attr)namedNodeMap.item(i);
                    Attr attrClone = document.createAttribute(attr.getName());
                    attrClone.setValue(attr.getValue());
                    ((Element)nodeClone).setAttributeNode(attrClone);
                    ++i;
                }
                break;
            }
            case 3: {
                nodeClone = document.createTextNode(((CharacterData)node).getData());
                break;
            }
            case 4: {
                nodeClone = document.createCDATASection(((CharacterData)node).getData());
                break;
            }
            case 5: {
                nodeClone = document.createEntityReference(node.getNodeName());
                break;
            }
            case 7: {
                nodeClone = document.createProcessingInstruction(((ProcessingInstruction)node).getTarget(), ((ProcessingInstruction)node).getData());
                break;
            }
            case 8: {
                nodeClone = document.createComment(((CharacterData)node).getData());
                break;
            }
            case 11: {
                nodeClone = document.createDocumentFragment();
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                Assert.isTrue(false, Policy.bind("assert.notSupported"));
                break;
            }
            default: {
                Assert.isTrue(false, Policy.bind("assert.unknownNodeType"));
            }
        }
        return nodeClone;
    }

    public static Element create(Document document, String name) {
        Assert.isNotNull(document);
        Assert.isTrue(document.getDocumentElement() == null);
        Assert.isNotNull(name);
        Element element = document.createElement(name);
        ElementEditor.declareNS(element, null, DAV_NS);
        document.appendChild(element);
        return element;
    }

    public static void declareNS(Element element, String prefix, String namespaceUrl) {
        Assert.isNotNull(element);
        Assert.isTrue(namespaceUrl != null || prefix == null && namespaceUrl == null);
        String name = XML_PREFIX + (prefix == null ? "" : ":" + prefix);
        String value = namespaceUrl == null ? "" : namespaceUrl;
        element.setAttribute(name, value);
    }

    public static String decodeHref(String href) {
        return URLDecoder.decode(href);
    }

    public static String encodeHref(String href) {
        return URLEncoder.encode(href);
    }

    protected static void ensure(String message, boolean value) throws MalformedElementException {
        if (!value) {
            throw new MalformedElementException(message);
        }
    }

    protected static void ensure(boolean value, String message) throws MalformedElementException {
        if (!value) {
            throw new MalformedElementException(message);
        }
    }

    protected static Element ensureDAVElement(String message, Node node, String name) throws MalformedElementException {
        Assert.isNotNull(name);
        if (node == null || node.getNodeType() != 1) {
            throw new MalformedElementException(message);
        }
        Element element = (Element)node;
        if (!name.equals(ElementEditor.getNSLocalName(element)) || !DAV_NS.equals(ElementEditor.getNSName(element))) {
            throw new MalformedElementException(message);
        }
        return element;
    }

    protected static void ensureDAVElement(Node node, String name, String message) throws MalformedElementException {
        Assert.isNotNull(name);
        if (node == null || node.getNodeType() != 1) {
            throw new MalformedElementException(message);
        }
        Element element = (Element)node;
        if (!name.equals(ElementEditor.getNSLocalName(element)) || !DAV_NS.equals(ElementEditor.getNSName(element))) {
            throw new MalformedElementException(message);
        }
    }

    protected static void ensureNotNull(String message, Object object) throws MalformedElementException {
        if (object == null) {
            throw new MalformedElementException(message);
        }
    }

    protected static void ensureNull(String message, Object object) throws MalformedElementException {
        if (object != null) {
            throw new MalformedElementException(message);
        }
    }

    protected static Text ensureText(String message, Node node) throws MalformedElementException {
        if (node == null || node.getNodeType() != 3) {
            throw new MalformedElementException(message);
        }
        return (Text)node;
    }

    public static Element extractElement(Document document, Element element) throws MalformedElementException {
        Assert.isNotNull(document);
        Assert.isTrue(document.getDocumentElement() == null);
        Assert.isNotNull(element);
        return (Element)ElementEditor.extractNode(document, element);
    }

    public static Node extractNode(Node parent, Node node) throws MalformedElementException {
        Document document = parent.getNodeType() == 9 ? (Document)parent : parent.getOwnerDocument();
        Node nodeClone = ElementEditor.cloneNode(document, node);
        parent.appendChild(nodeClone);
        if (node.getNodeType() == 1) {
            String nsNameClone;
            String nsPrefix = ElementEditor.getNSPrefix((Element)node);
            String nsName = ElementEditor.getNSName((Element)node);
            if (!(nsName == (nsNameClone = ElementEditor.resolve(nsPrefix, (Element)nodeClone)) || nsName != null && nsName.equals(nsNameClone))) {
                ElementEditor.declareNS((Element)nodeClone, nsPrefix, nsName);
            }
            NamedNodeMap nodeMap = nodeClone.getAttributes();
            int i = 0;
            while (i < nodeMap.getLength()) {
                Attr attr = (Attr)nodeMap.item(i);
                nsPrefix = ElementEditor.getNSPrefix(attr.getName());
                if (!(nsPrefix == null || nsPrefix.equals(XML_PREFIX) || (nsName = ElementEditor.resolve(nsPrefix, (Element)node)) == (nsNameClone = ElementEditor.resolve(nsPrefix, (Element)nodeClone)) || nsName != null && nsName.equals(nsNameClone))) {
                    ElementEditor.declareNS((Element)nodeClone, nsPrefix, nsName);
                }
                ++i;
            }
        }
        Node child = node.getFirstChild();
        while (child != null) {
            ElementEditor.extractNode(nodeClone, child);
            child = child.getNextSibling();
        }
        return nodeClone;
    }

    private static Element getChild(Element parent, String[] names, boolean firstToLast) {
        Assert.isTrue(ElementEditor.isDAVElement(parent));
        Assert.isNotNull(names);
        Node child = null;
        child = firstToLast ? parent.getFirstChild() : parent.getLastChild();
        while (child != null) {
            int i = 0;
            while (i < names.length) {
                if (ElementEditor.isDAVElement(child, names[i])) {
                    return (Element)child;
                }
                ++i;
            }
            child = firstToLast ? child.getNextSibling() : child.getPreviousSibling();
        }
        return null;
    }

    public static Element getChild(Element parent, String name, String[] names, boolean firstToLast) {
        Assert.isNotNull(parent);
        Assert.isNotNull(name);
        Assert.isNotNull(names);
        boolean found = false;
        int i = 0;
        while (!found && i < names.length) {
            found = names[i].equals(name);
            ++i;
        }
        Assert.isTrue(found);
        Node child = null;
        if (firstToLast) {
            i = 0;
            child = parent.getFirstChild();
        } else {
            i = names.length - 1;
            child = parent.getLastChild();
        }
        while (child != null && !names[i].equals(name)) {
            int mark = i;
            while (!ElementEditor.isDAVElement(child, names[i]) && !names[i].equals(name)) {
                if (firstToLast) {
                    ++i;
                    continue;
                }
                --i;
            }
            if (!names[i].equals(name)) {
                if (firstToLast) {
                    child = child.getNextSibling();
                    continue;
                }
                child = child.getPreviousSibling();
                continue;
            }
            if (ElementEditor.isDAVElement(child, names[i])) continue;
            int pos = i;
            found = false;
            while (!found && pos >= 0 && pos < names.length) {
                found = ElementEditor.isDAVElement(child, names[pos]);
                if (firstToLast) {
                    ++pos;
                    continue;
                }
                --pos;
            }
            if (found) continue;
            i = mark;
            child = firstToLast ? child.getNextSibling() : child.getPreviousSibling();
        }
        return (Element)child;
    }

    public static Element getChildElement(Element parent, boolean firstToLast) {
        Assert.isNotNull(parent);
        Node child = null;
        child = firstToLast ? parent.getFirstChild() : parent.getLastChild();
        while (child != null && !ElementEditor.isElement(child)) {
            child = firstToLast ? child.getNextSibling() : child.getPreviousSibling();
        }
        return (Element)child;
    }

    public static String getChildText(Element parent, String name, boolean firstToLast) {
        Assert.isTrue(ElementEditor.isDAVElement(parent));
        Assert.isNotNull(name);
        Element child = firstToLast ? ElementEditor.getFirstChild(parent, name) : ElementEditor.getLastChild(parent, name);
        if (child != null) {
            return ElementEditor.getText(child, firstToLast);
        }
        return null;
    }

    public static Element getDAVChild(Element parent) {
        Assert.isTrue(ElementEditor.isDAVElement(parent));
        Node child = parent.getFirstChild();
        while (child != null && !ElementEditor.isDAVElement(child)) {
            child = child.getNextSibling();
        }
        return (Element)child;
    }

    public Element getElement() {
        return this.root;
    }

    public static Element getFirstChild(Element parent, String[] names) {
        return ElementEditor.getChild(parent, names, true);
    }

    public static Element getFirstChild(Element parent, String name) {
        Assert.isNotNull(name);
        return ElementEditor.getChild(parent, new String[]{name}, true);
    }

    public static String getFirstText(Element parent) {
        Assert.isNotNull(parent);
        Node child = parent.getFirstChild();
        while (child != null && !ElementEditor.isText(child)) {
            child = child.getNextSibling();
        }
        if (child == null) {
            return "";
        }
        return ((Text)child).getData();
    }

    public static Element getLastChild(Element parent, String name) {
        Assert.isNotNull(name);
        return ElementEditor.getChild(parent, new String[]{name}, false);
    }

    public static Namespaces getNamespaces(Element element) {
        Assert.isNotNull(element);
        Node parent = element.getParentNode();
        while (parent != null && !ElementEditor.isElement(parent)) {
            parent = parent.getParentNode();
        }
        Namespaces namespaces = null;
        if (parent != null) {
            namespaces = ElementEditor.getNamespaces((Element)parent);
        }
        return ElementEditor.getNamespaces(element, namespaces, false);
    }

    protected static Namespaces getNamespaces(Element element, Namespaces namespaces, boolean removeDuplicateNSDeclarations) {
        Namespaces newNamespaces = null;
        newNamespaces = namespaces == null ? new Namespaces() : new Namespaces(namespaces);
        Vector<Attr> oldAttributes = new Vector<Attr>();
        NamedNodeMap nodeMap = element.getAttributes();
        int i = 0;
        while (i < nodeMap.getLength()) {
            Attr attr = (Attr)nodeMap.item(i);
            String name = attr.getName();
            if (name.startsWith(XML_PREFIX)) {
                String nsPrefix;
                String nsName = attr.getValue();
                if (name.length() == XML_PREFIX.length()) {
                    if (nsName.equals("")) {
                        newNamespaces.setDefaultNSName(null);
                    } else {
                        newNamespaces.setDefaultNSName(nsName);
                    }
                } else if (name.charAt(XML_PREFIX.length()) == ':' && (nsPrefix = name.substring(XML_PREFIX.length() + 1)).length() > 0 && nsName.length() > 0) {
                    boolean prefixExists;
                    newNamespaces.putNSName(nsPrefix, nsName);
                    boolean bl = prefixExists = newNamespaces.getNSPrefix(nsName) != null;
                    if (!prefixExists) {
                        newNamespaces.putNSPrefix(nsName, nsPrefix);
                    }
                    if (removeDuplicateNSDeclarations && (prefixExists || nsName.equals(newNamespaces.getDefaultNSName()))) {
                        oldAttributes.addElement(attr);
                    }
                }
            }
            ++i;
        }
        Enumeration e = oldAttributes.elements();
        while (e.hasMoreElements()) {
            element.removeAttributeNode((Attr)e.nextElement());
        }
        return newNamespaces;
    }

    public static Element getNextSibling(Element element) {
        Assert.isNotNull(element);
        Node sibling = element;
        while ((sibling = sibling.getNextSibling()) != null && !ElementEditor.isElement(sibling)) {
        }
        return sibling;
    }

    public static Element getNextSibling(Element element, String[] names) {
        Assert.isTrue(ElementEditor.isDAVElement(element));
        Assert.isNotNull(names);
        Node sibling = element.getNextSibling();
        while (sibling != null) {
            int i = 0;
            while (i < names.length) {
                if (ElementEditor.isDAVElement(sibling, names[i])) {
                    return (Element)sibling;
                }
                ++i;
            }
            sibling = sibling.getNextSibling();
        }
        return null;
    }

    public static Element getNextSibling(Element element, String name) {
        return ElementEditor.getNextSibling(element, new String[]{name});
    }

    public static String getNSLocalName(String name) {
        Assert.isNotNull(name);
        int p = name.lastIndexOf(58);
        if (p == -1) {
            return name;
        }
        if (p == name.length() - 1) {
            return null;
        }
        return name.substring(p + 1);
    }

    public static String getNSLocalName(Element element) {
        Assert.isNotNull(element);
        return ElementEditor.getNSLocalName(element.getTagName());
    }

    public static String getNSName(Element element) throws MalformedElementException {
        Assert.isNotNull(element);
        String nsPrefix = ElementEditor.getNSPrefix(element);
        String nsName = ElementEditor.resolve(nsPrefix, element);
        if (nsPrefix != null && nsName == null) {
            throw new MalformedElementException(Policy.bind("exception.namespacePrefixNotResolved", nsPrefix));
        }
        return nsName;
    }

    public static String getNSPrefix(String name) {
        Assert.isNotNull(name);
        int p = name.lastIndexOf(58);
        if (p <= 0) {
            return null;
        }
        return name.substring(0, p);
    }

    public static String getNSPrefix(Element element) {
        Assert.isNotNull(element);
        return ElementEditor.getNSPrefix(element.getTagName());
    }

    public static QualifiedName getQualifiedName(Element element) throws MalformedElementException {
        Assert.isNotNull(element);
        String nsName = ElementEditor.getNSName(element);
        String nsLocalName = ElementEditor.getNSLocalName(element);
        if (nsLocalName == null) {
            throw new MalformedElementException(Policy.bind("exception.noLocalNameForElmt"));
        }
        return new QualifiedNameImpl(nsName, nsLocalName);
    }

    public static Element getSibling(Element element, String name, boolean firstToLast) {
        Assert.isTrue(ElementEditor.isDAVElement(element));
        Assert.isNotNull(name);
        Node sibling = element;
        while ((sibling = firstToLast ? sibling.getNextSibling() : sibling.getPreviousSibling()) != null && !ElementEditor.isDAVElement(sibling, name)) {
        }
        return sibling;
    }

    public static String getText(Element parent, boolean firstToLast) {
        Assert.isNotNull(parent);
        Node child = null;
        child = firstToLast ? parent.getFirstChild() : parent.getLastChild();
        while (child != null && !ElementEditor.isText(child)) {
            child = firstToLast ? child.getNextSibling() : child.getPreviousSibling();
        }
        if (child != null) {
            return ((Text)child).getData();
        }
        return "";
    }

    public static Element getTwin(Element element, boolean firstToLast) {
        Assert.isTrue(ElementEditor.isDAVElement(element));
        String name = ElementEditor.getNSLocalName(element);
        return ElementEditor.getSibling(element, name, firstToLast);
    }

    public static boolean hasChild(Element parent, QualifiedName childName) throws MalformedElementException {
        Node child = parent.getFirstChild();
        while (child != null) {
            QualifiedName name;
            if (child instanceof Element && (name = ElementEditor.getQualifiedName((Element)child)).equals(childName)) {
                return true;
            }
            child = child.getNextSibling();
        }
        return false;
    }

    public static Element insertBefore(Element sibling, String name) {
        Assert.isTrue(ElementEditor.isDAVElement(sibling));
        Assert.isNotNull(name);
        String nsPrefix = ElementEditor.getNSPrefix(sibling);
        String tagName = nsPrefix == null ? name : String.valueOf(nsPrefix) + ":" + name;
        Element newSibling = sibling.getOwnerDocument().createElement(tagName);
        sibling.getParentNode().insertBefore(newSibling, sibling);
        return newSibling;
    }

    public static Element insertBefore(Element sibling, String name, String data) {
        Assert.isTrue(ElementEditor.isDAVElement(sibling));
        Assert.isNotNull(name);
        Assert.isNotNull(data);
        Element child = ElementEditor.insertBefore(sibling, name);
        child.appendChild(child.getOwnerDocument().createTextNode(data));
        return child;
    }

    public static boolean isDAVElement(Node node) {
        if (node == null || node.getNodeType() != 1) {
            return false;
        }
        try {
            return DAV_NS.equals(ElementEditor.getNSName((Element)node));
        }
        catch (MalformedElementException malformedElementException) {
            return false;
        }
    }

    public static boolean isDAVElement(Node node, String name) {
        Assert.isNotNull(name);
        if (node == null || node.getNodeType() != 1) {
            return false;
        }
        try {
            Element element = (Element)node;
            return name.equals(ElementEditor.getNSLocalName(element)) && DAV_NS.equals(ElementEditor.getNSName(element));
        }
        catch (MalformedElementException malformedElementException) {
            return false;
        }
    }

    public static boolean isElement(Node node) {
        return node != null && node.getNodeType() == 1;
    }

    public static boolean isText(Node node) {
        return node != null && node.getNodeType() == 3;
    }

    public static void makeNSStandalone(Element element) {
        Assert.isTrue(false, Policy.bind("assert.notImplemented"));
    }

    public static Element reduceNS(Element element) throws MalformedElementException {
        return (Element)ElementEditor.reduceNS(element, null);
    }

    public static Node reduceNS(Node node, Namespaces parentNamespaces) throws MalformedElementException {
        Namespaces namespaces = parentNamespaces;
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            namespaces = ElementEditor.getNamespaces(element, parentNamespaces, false);
            String nsPrefix = ElementEditor.getNSPrefix(element);
            String nsLocalName = ElementEditor.getNSLocalName(element);
            if (nsPrefix != null) {
                String nsName = namespaces.getNSName(nsPrefix);
                ElementEditor.ensureNotNull(Policy.bind("ensure.missingNamespaceForPrefix", nsPrefix), nsName);
                String tagName = null;
                tagName = nsName.equals(namespaces.getDefaultNSName()) ? nsLocalName : String.valueOf(namespaces.getNSPrefix(nsName)) + ":" + nsLocalName;
                if (!tagName.equals(element.getTagName())) {
                    Document document = element.getOwnerDocument();
                    Element newElement = document.createElement(tagName);
                    NamedNodeMap nodeMap = element.getAttributes();
                    int i = 0;
                    while (i < nodeMap.getLength()) {
                        Attr attr = (Attr)nodeMap.item(i);
                        newElement.setAttribute(attr.getName(), attr.getValue());
                        ++i;
                    }
                    Node child = element.getFirstChild();
                    while (child != null) {
                        element.removeChild(child);
                        newElement.appendChild(child);
                        child = element.getFirstChild();
                    }
                    element.getParentNode().replaceChild(newElement, element);
                    element = newElement;
                }
            }
            Vector<Attr> oldAttributes = new Vector<Attr>();
            Vector<String[]> newAttributes = new Vector<String[]>();
            NamedNodeMap nodeMap = element.getAttributes();
            int i = 0;
            while (i < nodeMap.getLength()) {
                Attr attr = (Attr)nodeMap.item(i);
                String name = attr.getName();
                String value = attr.getValue();
                String newName = name;
                nsPrefix = ElementEditor.getNSPrefix(name);
                nsLocalName = ElementEditor.getNSLocalName(name);
                if (nsPrefix != null && !nsPrefix.equals(XML_PREFIX)) {
                    String nsName = namespaces.getNSName(nsPrefix);
                    ElementEditor.ensureNotNull(Policy.bind("ensure.missingNamespaceForPrefix", nsPrefix), nsName);
                    String newNSPrefix = namespaces.getNSPrefix(nsName);
                    if (!newNSPrefix.equals(nsPrefix)) {
                        newName = String.valueOf(newNSPrefix) + ":" + nsLocalName;
                    }
                }
                boolean newAttribute = true;
                if (parentNamespaces != null) {
                    if (nsPrefix == null && XML_PREFIX.equals(nsLocalName) && value.equals(parentNamespaces.getDefaultNSName())) {
                        newAttribute = false;
                    }
                    if (nsPrefix != null && XML_PREFIX.equals(nsPrefix) && parentNamespaces.getNSPrefix(value) != null) {
                        newAttribute = false;
                    }
                }
                oldAttributes.addElement(attr);
                if (newAttribute) {
                    newAttributes.addElement(new String[]{newName, value});
                }
                ++i;
            }
            Enumeration oldAttrs = oldAttributes.elements();
            while (oldAttrs.hasMoreElements()) {
                element.removeAttributeNode((Attr)oldAttrs.nextElement());
            }
            Enumeration newAttrs = newAttributes.elements();
            while (newAttrs.hasMoreElements()) {
                String[] newAttr = (String[])newAttrs.nextElement();
                element.setAttribute(newAttr[0], newAttr[1]);
            }
            node = element;
        }
        Node child = node.getFirstChild();
        while (child != null) {
            child = ElementEditor.reduceNS(child, namespaces);
            child = child.getNextSibling();
        }
        return node;
    }

    public static String resolve(String prefix, Element element) {
        Assert.isNotNull(element);
        if (XML_NS_PREFIX.equals(prefix)) {
            return XML_NS_NAME;
        }
        Node current = element;
        do {
            NamedNodeMap attrs = current.getAttributes();
            int n = attrs.getLength();
            int i = 0;
            while (i < n) {
                Attr attr = (Attr)attrs.item(i);
                String name = attr.getName();
                if (name.startsWith(XML_PREFIX)) {
                    if (name.length() == XML_PREFIX.length()) {
                        if (prefix == null) {
                            String nsName = attr.getValue();
                            if (nsName.equals("")) {
                                return null;
                            }
                            return nsName;
                        }
                    } else if (prefix != null && name.equals("xmlns:" + prefix)) {
                        return attr.getValue();
                    }
                }
                ++i;
            }
            while ((current = current.getParentNode()) != null && current.getNodeType() != 1) {
            }
        } while (current != null);
        return null;
    }

    public static Element setChild(Element parent, String name, String[] names, boolean firstToLast) {
        Assert.isTrue(ElementEditor.isDAVElement(parent));
        Assert.isNotNull(name);
        Assert.isNotNull(names);
        String nsPrefix = ElementEditor.getNSPrefix(parent);
        String tagName = nsPrefix == null ? name : String.valueOf(nsPrefix) + ":" + name;
        Element child = parent.getOwnerDocument().createElement(tagName);
        ElementEditor.setChild(parent, child, names, firstToLast);
        return child;
    }

    public static Element setChild(Element parent, String name, String data, String[] names, boolean firstToLast) {
        Assert.isTrue(ElementEditor.isDAVElement(parent));
        Assert.isNotNull(name);
        Assert.isNotNull(data);
        Assert.isNotNull(names);
        Element child = ElementEditor.setChild(parent, name, names, firstToLast);
        child.appendChild(parent.getOwnerDocument().createTextNode(data));
        return child;
    }

    public static void setChild(Element parent, Element child, String[] names, boolean firstToLast) {
        Assert.isTrue(ElementEditor.isDAVElement(parent));
        Assert.isNotNull(child);
        Assert.isTrue(DAV_NS.equals(ElementEditor.resolve(ElementEditor.getNSPrefix(child), parent)));
        Assert.isNotNull(names);
        boolean found = false;
        String name = ElementEditor.getNSLocalName(child);
        int i = 0;
        while (!found && i < names.length) {
            found = names[i].equals(name);
            ++i;
        }
        Assert.isTrue(found);
        Element sibling = ElementEditor.getChild(parent, name, names, firstToLast);
        if (ElementEditor.isDAVElement(sibling, name)) {
            parent.replaceChild(child, sibling);
        } else if (firstToLast) {
            if (sibling == null) {
                parent.appendChild(child);
            } else {
                parent.insertBefore(child, sibling);
            }
        } else {
            Node refChild = null;
            refChild = sibling == null ? parent.getFirstChild() : sibling.getNextSibling();
            if (refChild == null) {
                parent.appendChild(child);
            } else {
                parent.insertBefore(child, refChild);
            }
        }
    }
}

