/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.authentication;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestOutputStream
extends FilterOutputStream {
    private MessageDigest messageDigest = null;
    private byte[] digest = null;

    public DigestOutputStream(OutputStream out, String algorithm) throws NoSuchAlgorithmException {
        super(out);
        this.messageDigest = MessageDigest.getInstance(algorithm);
    }

    public DigestOutputStream(String algorithm) throws NoSuchAlgorithmException {
        this(new NullOutputStream(), algorithm);
    }

    public byte[] digest() {
        if (this.digest == null) {
            this.digest = this.messageDigest.digest();
        }
        return this.digest;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.messageDigest.update(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        this.messageDigest.update((byte)b);
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }
}

