/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse;

import java.net.MalformedURLException;
import java.net.URL;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class DroolsPluginImages {
    public static final String IMG_LOGICAL = "ImageLogical";
    public static final String IMG_LOGICAL_DISABLED = "ImageLogicalDisabled";
    public static final String REFRESH_LOG = "RefreshLog";
    public static final String REFRESH_LOG_DISABLED = "RefreshLogDisabled";
    public static final String OPEN_LOG = "OpenLog";
    public static final String DELETE_LOG = "ClearLog";
    public static final String DELETE_LOG_DISABLED = "ClearLogDisabled";
    public static final String INSERT = "Insert";
    public static final String UPDATE = "Update";
    public static final String RETRACT = "RetractO";
    public static final String CREATE_ACTIVATION = "CreateActivation";
    public static final String CANCEL_ACTIVATION = "CancelActivation";
    public static final String EXECUTE_ACTIVATION = "ExecuteActivation";
    public static final String CLASS = "Class";
    public static final String PACKAGE = "Package";
    public static final String METHOD = "Method";
    public static final String VARIABLE = "Variable";
    public static final String DROOLS = "Drools";
    public static final String RULE = "DroolsRule";
    public static final String QUERY = "DroolsQuery";
    public static final String DSL_EXPRESSION = "DslExpression";
    public static final String IMPORT = "Import";
    public static final String DSL = "DSL";
    public static final String GLOBAL = "Global";
    public static final String RULEFLOW = "RuleFlow";
    public static final String RULEFLOW_GROUP = "RuleFlowGroup";
    public static final String RULEFLOW_NODE_TRIGGERED = "RuleFlowNodeTriggered";
    public static final String RULEGROUP = "RuleGroup";
    public static final String DEFAULTRULEGROUP = "DefaultRuleGroup";
    public static final String GROUPS = "RuleFlowGroup";
    private static ImageRegistry imageRegistry;
    private static final String PATH_SUFFIX = "/icons/";
    private static final URL ICON_BASE_URL;

    static {
        ICON_BASE_URL = DroolsEclipsePlugin.getDefault().getBundle().getEntry(PATH_SUFFIX);
    }

    private static void declareImages() {
        DroolsPluginImages.declareRegistryImage(IMG_LOGICAL, "logical_structure.gif");
        DroolsPluginImages.declareRegistryImage(IMG_LOGICAL_DISABLED, "logical_structure_disabled.gif");
        DroolsPluginImages.declareRegistryImage(REFRESH_LOG, "refresh.gif");
        DroolsPluginImages.declareRegistryImage(REFRESH_LOG_DISABLED, "refresh_disabled.gif");
        DroolsPluginImages.declareRegistryImage(OPEN_LOG, "open.gif");
        DroolsPluginImages.declareRegistryImage(DELETE_LOG, "clear.gif");
        DroolsPluginImages.declareRegistryImage(DELETE_LOG_DISABLED, "clear_disabled.gif");
        DroolsPluginImages.declareRegistryImage(INSERT, "greensquare.GIF");
        DroolsPluginImages.declareRegistryImage(UPDATE, "yellowsquare.GIF");
        DroolsPluginImages.declareRegistryImage(RETRACT, "redsquare.GIF");
        DroolsPluginImages.declareRegistryImage(CREATE_ACTIVATION, "arrowright.GIF");
        DroolsPluginImages.declareRegistryImage(CANCEL_ACTIVATION, "arrowleft.GIF");
        DroolsPluginImages.declareRegistryImage(EXECUTE_ACTIVATION, "bluediamond.GIF");
        DroolsPluginImages.declareRegistryImage(CLASS, "class_obj.gif");
        DroolsPluginImages.declareRegistryImage(PACKAGE, "package_obj.gif");
        DroolsPluginImages.declareRegistryImage(METHOD, "methpub_obj.gif");
        DroolsPluginImages.declareRegistryImage(VARIABLE, "field_private_obj.gif");
        DroolsPluginImages.declareRegistryImage(DROOLS, "drools.gif");
        DroolsPluginImages.declareRegistryImage(RULE, "drools-rule.GIF");
        DroolsPluginImages.declareRegistryImage(QUERY, "drools-query.GIF");
        DroolsPluginImages.declareRegistryImage(DSL_EXPRESSION, "dsl_expression.gif");
        DroolsPluginImages.declareRegistryImage(IMPORT, "import.gif");
        DroolsPluginImages.declareRegistryImage(DSL, "dsl.GIF");
        DroolsPluginImages.declareRegistryImage(GLOBAL, "field_public_obj.gif");
        DroolsPluginImages.declareRegistryImage(RULEFLOW, "process.gif");
        DroolsPluginImages.declareRegistryImage("RuleFlowGroup", "activity.gif");
        DroolsPluginImages.declareRegistryImage(RULEFLOW_NODE_TRIGGERED, "node-triggered.gif");
        DroolsPluginImages.declareRegistryImage(RULEGROUP, "package_obj.gif");
        DroolsPluginImages.declareRegistryImage(DEFAULTRULEGROUP, "package_obj.gif");
    }

    public static final void declareRegistryImage(String key, String path) {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        try {
            desc = ImageDescriptor.createFromURL((URL)DroolsPluginImages.makeIconFileURL(path));
        }
        catch (MalformedURLException e) {
            DroolsEclipsePlugin.log(e);
        }
        imageRegistry.put(key, desc);
    }

    public static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            DroolsPluginImages.initializeImageRegistry();
        }
        return imageRegistry;
    }

    public static ImageRegistry initializeImageRegistry() {
        imageRegistry = new ImageRegistry();
        DroolsPluginImages.declareImages();
        return imageRegistry;
    }

    public static Image getImage(String key) {
        return DroolsPluginImages.getImageRegistry().get(key);
    }

    public static void putImage(String key, Image image) {
        DroolsPluginImages.getImageRegistry().put(key, image);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return DroolsPluginImages.getImageRegistry().getDescriptor(key);
    }

    private static URL makeIconFileURL(String iconPath) throws MalformedURLException {
        if (ICON_BASE_URL == null) {
            throw new MalformedURLException();
        }
        return new URL(ICON_BASE_URL, iconPath);
    }
}

