/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.rete.commands;

import org.drools.eclipse.reteoo.BaseVertex;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class NodeSetConstraintCommand
extends Command {
    private final Rectangle newBounds;
    private Rectangle oldBounds;
    private final ChangeBoundsRequest request;
    private final BaseVertex vertex;

    public NodeSetConstraintCommand(BaseVertex vertex, ChangeBoundsRequest req, Rectangle newBounds) {
        if (vertex == null || req == null || newBounds == null) {
            throw new IllegalArgumentException();
        }
        this.vertex = vertex;
        this.request = req;
        this.newBounds = newBounds.getCopy();
    }

    public boolean canExecute() {
        Object type = this.request.getType();
        return "move".equals(type) || "move children".equals(type);
    }

    public void execute() {
        this.oldBounds = new Rectangle(this.vertex.getLocation(), this.vertex.getSize());
        this.redo();
    }

    public void redo() {
        this.vertex.setSize(this.newBounds.getSize());
        this.vertex.setLocation(this.newBounds.getLocation());
    }

    public void undo() {
        this.vertex.setSize(this.oldBounds.getSize());
        this.vertex.setLocation(this.oldBounds.getLocation());
    }
}

