/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor.core.command;

import org.drools.eclipse.flow.common.editor.core.ElementConnection;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.eclipse.gef.commands.Command;

public class ReconnectElementConnectionTargetCommand
extends Command {
    private ElementConnection connection;
    private ElementWrapper oldTarget;
    private ElementWrapper newTarget;
    private ElementWrapper source;

    public boolean canExecute() {
        if (this.connection.getSource().equals(this.newTarget)) {
            return false;
        }
        for (ElementConnection connection : this.newTarget.getIncomingConnections()) {
            if (!connection.getSource().equals(this.source) || connection.getTarget().equals(this.oldTarget)) continue;
            return false;
        }
        return this.newTarget.acceptsIncomingConnection(this.connection, this.source);
    }

    public void execute() {
        if (this.newTarget != null) {
            this.connection.disconnect();
            this.connection.connect(this.source, this.newTarget);
        }
    }

    public void setTarget(ElementWrapper target) {
        this.newTarget = target;
    }

    public void setConnection(ElementConnection connection) {
        this.connection = connection;
        this.source = connection.getSource();
        this.oldTarget = connection.getTarget();
    }

    public void undo() {
        this.connection.disconnect();
        this.connection.connect(this.source, this.oldTarget);
    }

    public void redo() {
        this.connection.disconnect();
        this.connection.connect(this.source, this.newTarget);
    }
}

