/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.wizard.decisiontable;

import java.io.IOException;
import java.io.InputStream;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class NewDTFilePage
extends WizardNewFileCreationPage {
    private static final String XLS_EXTENSION = ".xls";
    private IWorkbench workbench;

    public NewDTFilePage(IWorkbench workbench, IStructuredSelection selection) {
        super("createDTFilePage", selection);
        this.setTitle("New Decision Table");
        this.setDescription("Create a new Decision Table scaffolding.");
        this.workbench = workbench;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setPageComplete(true);
    }

    public boolean finish() {
        IFile newFile;
        String fileName = this.getFileName();
        if (!fileName.endsWith(XLS_EXTENSION)) {
            this.setFileName(String.valueOf(fileName) + XLS_EXTENSION);
        }
        if ((newFile = this.createNewFile()) == null) {
            return false;
        }
        try {
            IWorkbenchWindow dwindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = dwindow.getActivePage();
            if (page != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)newFile, (boolean)true);
            }
        }
        catch (PartInitException e) {
            DroolsEclipsePlugin.log(e);
            return false;
        }
        return true;
    }

    protected InputStream getInitialContents() {
        try {
            return DroolsEclipsePlugin.getDefault().getBundle().getResource("org/drools/eclipse/wizard/decisiontable/template.xls").openStream();
        }
        catch (IOException iOException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }
}

