/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.preferences;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class PasswordFieldEditor
extends FieldEditor {
    public static int UNLIMITED = -1;
    protected String oldValue;
    Text textField;
    private int widthInChars = UNLIMITED;

    public PasswordFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    public void setStringValue(String value) {
        if (this.textField != null) {
            if (value == null) {
                value = "";
            }
            this.oldValue = this.textField.getText();
            if (!this.oldValue.equals(value)) {
                this.textField.setText(value);
                this.valueChanged();
            }
        }
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.textField.getLayoutData();
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        this.textField = this.getTextControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns - 1;
        if (this.widthInChars != UNLIMITED) {
            GC gc = new GC((Drawable)this.textField);
            try {
                Point extent = gc.textExtent("X");
                gd.widthHint = this.widthInChars * extent.x;
            }
            finally {
                gc.dispose();
            }
        } else {
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
        }
        this.textField.setLayoutData((Object)gd);
    }

    public Text getTextControl(Composite parent) {
        if (this.textField == null) {
            this.textField = new Text(parent, 0x400804);
            this.textField.setFont(parent.getFont());
        }
        return this.textField;
    }

    protected void valueChanged() {
        this.setPresentsDefaultValue(false);
        String newValue = this.textField.getText();
        if (!newValue.equals(this.oldValue)) {
            this.fireValueChanged("field_editor_value", this.oldValue, newValue);
            this.oldValue = newValue;
        }
    }

    protected void doLoad() {
        if (this.textField != null) {
            String value = this.getPreferenceStore().getString(this.getPreferenceName());
            this.textField.setText(value);
            this.oldValue = value;
        }
    }

    protected void doLoadDefault() {
        if (this.textField != null) {
            String value = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            this.textField.setText(value);
        }
        this.valueChanged();
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.textField.getText());
    }

    public int getNumberOfControls() {
        return 2;
    }
}

