/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.view;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.CommonViewerSiteFactory;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.navigator.NavigatorActionService;
import org.eclipse.ui.part.PageBook;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerEvent;
import org.kie.eclipse.navigator.KieNavigatorContentRoot;
import org.kie.eclipse.navigator.view.IKieNavigatorView;
import org.kie.eclipse.navigator.view.UpdateServerJob;
import org.kie.eclipse.navigator.view.content.IContentNode;
import org.kie.eclipse.navigator.view.utils.ViewUtils;
import org.kie.eclipse.server.KieResourceHandler;

public class KieNavigatorView
extends CommonNavigator
implements IKieNavigatorView,
IResourceChangeListener {
    private static final String KIE_NAVIGATOR_VIEW_CONTEXT = "org.kie.eclipse.navigator.context";
    protected CommonViewer treeViewer;
    private Control mainPage;
    private Control noServersPage;
    PageBook book;
    protected IServerLifecycleListener serverResourceListener;
    protected IServerListener serverListener;
    protected static Set<String> starting = new HashSet<String>(4);
    protected boolean animationActive = false;
    protected boolean stopAnimation = false;

    protected Object getInitialInput() {
        KieNavigatorContentRoot root = new KieNavigatorContentRoot(this);
        return root;
    }

    public void createPartControl(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        this.book = new PageBook(parent, 0);
        super.createPartControl((Composite)this.book);
        this.mainPage = this.getCommonViewer().getControl();
        this.noServersPage = this.createDefaultPage(toolkit);
        this.book.showPage(this.mainPage);
        IContextService contextSupport = (IContextService)this.getSite().getService(IContextService.class);
        contextSupport.activateContext(KIE_NAVIGATOR_VIEW_CONTEXT);
        this.deferInitialization();
    }

    protected CommonViewer createCommonViewerObject(Composite aParent) {
        return new CommonViewer(this.getViewSite().getId(), aParent, 770){

            public ISelection getSelection() {
                return super.getSelection();
            }

            protected void associate(Object element, Item item) {
                Object data;
                IProject project;
                if (!(!(element instanceof IProject) || (project = (IProject)element).exists() && project.isOpen() || (data = item.getData("org.kie.navigator.content.node")) == null)) {
                    element = data;
                }
                super.associate(element, item);
                if (element instanceof IContentNode) {
                    item.setData("org.kie.navigator.content.node", element);
                }
            }

            public ViewerComparator getComparator() {
                return null;
            }
        };
    }

    private Control createDefaultPage(FormToolkit kit) {
        ICommonViewerWorkbenchSite commonViewerSite;
        Form form = kit.createForm((Composite)this.book);
        Composite body = form.getBody();
        GridLayout layout = new GridLayout(2, false);
        body.setLayout((Layout)layout);
        Link hlink = new Link(body, 0);
        hlink.setText("<a>Use the Servers View to create a new server...</a>");
        hlink.setBackground(this.book.getDisplay().getSystemColor(25));
        GridData gd = new GridData(16384, 4, true, false);
        hlink.setLayoutData((Object)gd);
        hlink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewUtils.showServersView();
            }
        });
        final CommonViewer commonViewer = this.getCommonViewer();
        if (commonViewer != null && (commonViewerSite = CommonViewerSiteFactory.createCommonViewerSite((IViewSite)this.getViewSite())) != null) {
            final NavigatorActionService actionService = new NavigatorActionService((ICommonViewerSite)commonViewerSite, (StructuredViewer)commonViewer, commonViewer.getNavigatorContentService());
            MenuManager menuManager = new MenuManager("#PopupMenu");
            menuManager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager mgr) {
                    ISelection selection = commonViewer.getSelection();
                    actionService.setContext(new ActionContext(selection));
                    actionService.fillContextMenu(mgr);
                }
            });
            Menu menu = menuManager.createContextMenu((Control)body);
            body.setMenu(menu);
            hlink.setMenu(menu);
        }
        return form;
    }

    void toggleDefaultPage() {
        if (this.treeViewer.getTree().getItemCount() < 1) {
            this.book.showPage(this.noServersPage);
        } else {
            this.book.showPage(this.mainPage);
        }
    }

    private void deferInitialization() {
        Job job = new Job("Initializing Servers View"){

            public IStatus run(IProgressMonitor monitor) {
                IServer[] servers = ServerCore.getServers();
                int size = servers.length;
                int i = 0;
                while (i < size) {
                    servers[i].getModules();
                    ++i;
                }
                KieNavigatorView.this.deferredInitialize();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(20);
        job.schedule();
    }

    public void refresh() {
    }

    protected void deferredInitialize() {
        this.addListener();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    KieNavigatorView.this.treeViewer = KieNavigatorView.this.getCommonViewer();
                    KieNavigatorView.this.getSite().setSelectionProvider((ISelectionProvider)KieNavigatorView.this.treeViewer);
                }
                catch (Exception exception) {}
            }
        });
        UpdateServerJob job = new UpdateServerJob(ServerCore.getServers());
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if ((this).KieNavigatorView.this.treeViewer.getTree().getItemCount() > 0) {
                                Object obj = (this).KieNavigatorView.this.treeViewer.getTree().getItem(0).getData();
                                (this).KieNavigatorView.this.treeViewer.setSelection((ISelection)new StructuredSelection(obj));
                            } else {
                                KieNavigatorView.this.toggleDefaultPage();
                            }
                        }
                        catch (Exception exception) {}
                    }
                });
            }
        });
        job.schedule();
    }

    protected void refreshServerContent(final IServer server) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!KieNavigatorView.this.treeViewer.getTree().isDisposed()) {
                    Object[] expanded = KieNavigatorView.this.treeViewer.getExpandedElements();
                    KieNavigatorView.this.treeViewer.refresh((Object)server, true);
                    KieNavigatorView.this.treeViewer.setExpandedElements(expanded);
                }
            }
        });
    }

    protected void refreshServerState(IServer server) {
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IResourceDelta delta = event.getDelta();
                if (delta != null) {
                    try {
                        delta.accept(new IResourceDeltaVisitor(){

                            public boolean visit(IResourceDelta delta) throws CoreException {
                                IResource resource = delta.getResource();
                                if (resource instanceof IProject) {
                                    switch (delta.getKind()) {
                                        case 1: 
                                        case 2: {
                                            KieNavigatorContentRoot root = (KieNavigatorContentRoot)(this).KieNavigatorView.this.treeViewer.getInput();
                                            root.getChildren();
                                            (this).KieNavigatorView.this.treeViewer.refresh((Object)root, true);
                                            return false;
                                        }
                                    }
                                }
                                return true;
                            }
                        });
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    protected void addListener() {
        this.serverResourceListener = new IServerLifecycleListener(){

            public void serverAdded(IServer server) {
                KieNavigatorView.this.addServer(server);
                server.addServerListener(KieNavigatorView.this.serverListener);
            }

            public void serverChanged(IServer server) {
                KieNavigatorView.this.refreshServerContent(server);
            }

            public void serverRemoved(IServer server) {
                KieNavigatorView.this.removeServer(server);
                server.removeServerListener(KieNavigatorView.this.serverListener);
            }
        };
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)this.serverResourceListener);
        this.serverListener = new IServerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serverChanged(ServerEvent event) {
                if (event == null) {
                    return;
                }
                int eventKind = event.getKind();
                IServer server = event.getServer();
                if ((eventKind & 0x10) != 0) {
                    if ((eventKind & 1) != 0) {
                        int state = event.getState();
                        String id = server.getId();
                        if (state == 1 || state == 3) {
                            boolean startThread = false;
                            Set<String> set = starting;
                            synchronized (set) {
                                if (!starting.contains(id)) {
                                    if (starting.isEmpty()) {
                                        startThread = true;
                                    }
                                    starting.add(id);
                                }
                            }
                            if (startThread) {
                                KieNavigatorView.this.startThread();
                            }
                        } else {
                            boolean stopThread = false;
                            Set<String> set = starting;
                            synchronized (set) {
                                if (starting.contains(id)) {
                                    starting.remove(id);
                                    if (starting.isEmpty()) {
                                        stopThread = true;
                                    }
                                }
                            }
                            if (stopThread) {
                                KieNavigatorView.this.stopThread();
                            }
                        }
                        KieNavigatorView.this.refreshServerState(server);
                        KieNavigatorView.this.refreshServerContent(server);
                    } else if ((eventKind & 2) != 0 || (eventKind & 8) != 0) {
                        KieNavigatorView.this.refreshServerState(server);
                    }
                } else if ((eventKind & 0x20) != 0 && ((eventKind & 1) != 0 || (eventKind & 2) != 0 || (eventKind & 8) != 0)) {
                    KieNavigatorView.this.refreshServerContent(server);
                }
            }
        };
        IServer[] servers = ServerCore.getServers();
        if (servers != null) {
            int size = servers.length;
            int i = 0;
            while (i < size) {
                servers[i].addServerListener(this.serverListener);
                ++i;
            }
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    protected void addServer(IServer server) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                KieNavigatorContentRoot root = new KieNavigatorContentRoot(KieNavigatorView.this);
                KieNavigatorView.this.treeViewer.setInput((Object)root);
                KieNavigatorView.this.toggleDefaultPage();
            }
        });
    }

    protected void removeServer(final IServer server) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                KieNavigatorContentRoot root = new KieNavigatorContentRoot(KieNavigatorView.this);
                KieNavigatorView.this.treeViewer.setInput((Object)root);
                KieNavigatorView.this.toggleDefaultPage();
                KieResourceHandler.removeServerPreferences((IServer)server);
            }
        });
    }

    public void dispose() {
        ServerCore.removeServerLifecycleListener((IServerLifecycleListener)this.serverResourceListener);
        IServer[] servers = ServerCore.getServers();
        if (servers != null) {
            int size = servers.length;
            int i = 0;
            while (i < size) {
                servers[i].removeServerListener(this.serverListener);
                ++i;
            }
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    protected void startThread() {
        Runnable[] animator;
        if (this.animationActive) {
            return;
        }
        this.stopAnimation = false;
        final Display display = this.treeViewer == null ? Display.getDefault() : this.treeViewer.getControl().getDisplay();
        animator = new Runnable[]{new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!KieNavigatorView.this.stopAnimation) {
                    try {
                        String[] servers;
                        int size = 0;
                        Set<String> set = starting;
                        synchronized (set) {
                            size = starting.size();
                            servers = new String[size];
                            starting.toArray(servers);
                        }
                        int i = 0;
                        while (i < size) {
                            IServer server = ServerCore.findServer((String)servers[i]);
                            if (server != null) {
                                KieNavigatorView.this.treeViewer.update((Object)server, new String[]{"ICON"});
                            }
                            ++i;
                        }
                    }
                    catch (Exception exception) {}
                    display.timerExec(200, animator[0]);
                }
            }
        }};
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                display.timerExec(200, animator[0]);
            }
        });
    }

    protected void stopThread() {
        this.stopAnimation = true;
    }

    @Override
    public void refresh(Object element) {
        this.getCommonViewer().refresh(element);
    }

    @Override
    public void setProperty(String key, String value) {
        this.setPartProperty(key, value);
    }

    @Override
    public String getProperty(String key) {
        return this.getPartProperty(key);
    }
}

