/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.utils;

import java.io.File;
import java.util.Set;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.util.FS;

public class GitUtils {
    private GitUtils() {
    }

    public static RepositoryUtil getRepositoryUtil() {
        return Activator.getDefault().getRepositoryUtil();
    }

    public static void findGitDirsRecursive(File repoRoot, Set<File> gitDirs, boolean lookForNestedRepositories) {
        if (!repoRoot.exists() || !repoRoot.isDirectory()) {
            return;
        }
        File[] children = repoRoot.listFiles();
        if (children == null) {
            return;
        }
        File[] fileArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            if (child.isDirectory()) {
                if (RepositoryCache.FileKey.isGitRepository((File)child, (FS)FS.DETECTED)) {
                    gitDirs.add(child);
                } else if (RepositoryCache.FileKey.isGitRepository((File)new File(child, ".git"), (FS)FS.DETECTED)) {
                    gitDirs.add(new File(child, ".git"));
                } else if (lookForNestedRepositories) {
                    GitUtils.findGitDirsRecursive(child, gitDirs, lookForNestedRepositories);
                }
            }
            ++n2;
        }
    }
}

