/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.authentication;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.eclipse.webdav.IContext;
import org.eclipse.webdav.IResponse;
import org.eclipse.webdav.http.client.IAuthenticator;
import org.eclipse.webdav.http.client.Request;
import org.eclipse.webdav.internal.authentication.AuthenticateChallenge;
import org.eclipse.webdav.internal.authentication.DigestOutputStream;
import org.eclipse.webdav.internal.authentication.HexConverter;
import org.eclipse.webdav.internal.authentication.ParserException;
import org.eclipse.webdav.internal.kernel.utils.Assert;

public class AuthorizationAuthority {
    public static String[] authenticationSchemes = new String[]{"Digest", "Basic"};
    protected IAuthenticator authenticatorStore = null;

    public AuthorizationAuthority(IAuthenticator authenticatorStore) {
        Assert.isNotNull(authenticatorStore);
        this.authenticatorStore = authenticatorStore;
    }

    public boolean authorize(Request request, IResponse response, IContext context, URL proxyServerUrl, boolean isProxyAuthorization) {
        String realm;
        String authScheme;
        Assert.isNotNull(request);
        Assert.isNotNull(context);
        URL serverUrl = null;
        URL protectionSpaceUrl = null;
        if (isProxyAuthorization) {
            if (proxyServerUrl == null) {
                return false;
            }
            serverUrl = proxyServerUrl;
            protectionSpaceUrl = proxyServerUrl;
        } else {
            URL resourceUrl = request.getResourceUrl();
            try {
                serverUrl = new URL(resourceUrl.getProtocol(), resourceUrl.getHost(), resourceUrl.getPort(), "/");
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
            protectionSpaceUrl = resourceUrl;
        }
        if (response != null) {
            String challengeString = null;
            challengeString = isProxyAuthorization ? response.getContext().getProxyAuthenticate() : response.getContext().getWWWAuthenticate();
            if (challengeString == null) {
                return false;
            }
            AuthenticateChallenge challenge = null;
            try {
                challenge = new AuthenticateChallenge(challengeString);
            }
            catch (ParserException parserException) {
                return false;
            }
            authScheme = challenge.getAuthScheme();
            String realm2 = challenge.getRealm();
            AuthorizationAuthority authority = this.getAuthorizationAuthority(authScheme);
            if (authority == null) {
                return false;
            }
            Map oldInfo = this.authenticatorStore.getAuthenticationInfo(serverUrl, realm2, authScheme);
            Map info = authority.getAuthenticationInfo(challenge, oldInfo, serverUrl, protectionSpaceUrl);
            if (info == null) {
                return false;
            }
            this.authenticatorStore.addAuthenticationInfo(serverUrl, realm2, authScheme, info);
            this.authenticatorStore.addProtectionSpace(protectionSpaceUrl, realm2);
        }
        if ((realm = this.authenticatorStore.getProtectionSpace(protectionSpaceUrl)) == null) {
            return false;
        }
        Map info = null;
        authScheme = null;
        int i = 0;
        while (i < authenticationSchemes.length) {
            authScheme = authenticationSchemes[i];
            info = this.authenticatorStore.getAuthenticationInfo(serverUrl, realm, authScheme);
            if (info != null) break;
            ++i;
        }
        if (info == null) {
            return false;
        }
        AuthorizationAuthority authority = this.getAuthorizationAuthority(authScheme);
        if (authority == null) {
            return false;
        }
        String authorization = authority.getAuthorization(request, info, serverUrl, protectionSpaceUrl, proxyServerUrl);
        if (authorization == null) {
            return false;
        }
        if (isProxyAuthorization) {
            if (authorization.equals(context.getProxyAuthorization())) {
                return false;
            }
            context.setProxyAuthorization(authorization);
        } else {
            if (authorization.equals(context.getAuthorization())) {
                return false;
            }
            context.setAuthorization(authorization);
        }
        return true;
    }

    public boolean confirm(Request request, IResponse response, URL proxyServerUrl) {
        Assert.isNotNull(request);
        Assert.isNotNull(response);
        URL resourceUrl = request.getResourceUrl();
        URL serverUrl = null;
        try {
            serverUrl = new URL(resourceUrl.getProtocol(), resourceUrl.getHost(), resourceUrl.getPort(), "/");
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        String realm = this.authenticatorStore.getProtectionSpace(resourceUrl);
        if (realm == null) {
            return false;
        }
        Map info = null;
        String authScheme = null;
        int i = 0;
        while (i < authenticationSchemes.length) {
            authScheme = authenticationSchemes[i];
            info = this.authenticatorStore.getAuthenticationInfo(serverUrl, realm, authScheme);
            if (info != null) break;
            ++i;
        }
        if (info == null) {
            return false;
        }
        AuthorizationAuthority authority = this.getAuthorizationAuthority(authScheme);
        if (authority == null) {
            return false;
        }
        return authority.confirmResponse(request, response, proxyServerUrl);
    }

    protected boolean confirmResponse(Request request, IResponse response, URL proxyServerUrl) {
        Assert.isNotNull(request);
        Assert.isNotNull(response);
        return false;
    }

    protected Map getAuthenticationInfo(AuthenticateChallenge challenge, Map oldInfo, URL serverUrl, URL protectionSpaceUrl) {
        Assert.isNotNull(challenge);
        Assert.isNotNull(serverUrl);
        Assert.isNotNull(protectionSpaceUrl);
        return null;
    }

    protected String getAuthorization(Request request, Map info, URL serverUrl, URL protectionSpaceUrl, URL proxyServerUrl) {
        Assert.isNotNull(request);
        Assert.isNotNull(info);
        Assert.isNotNull(serverUrl);
        Assert.isNotNull(protectionSpaceUrl);
        return null;
    }

    private AuthorizationAuthority getAuthorizationAuthority(String scheme) {
        try {
            scheme = String.valueOf(Character.toUpperCase(scheme.charAt(0))) + scheme.substring(1).toLowerCase();
            String packageName = "org.eclipse.webdav.internal.authentication";
            String className = String.valueOf(scheme) + "Authority";
            Class<?> clazz = Class.forName(String.valueOf(packageName) + "." + className);
            Constructor<?> constructor = clazz.getConstructor(IAuthenticator.class);
            return (AuthorizationAuthority)constructor.newInstance(this.authenticatorStore);
        }
        catch (ClassCastException classCastException) {
        }
        catch (Exception exception) {}
        return null;
    }

    protected String md5(String s) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        byte[] hash = md5.digest(s.getBytes("UTF8"));
        return HexConverter.toHex(hash);
    }

    protected String md5(Request request) throws NoSuchAlgorithmException, IOException {
        DigestOutputStream dos = new DigestOutputStream("MD5");
        request.write(dos);
        String result = HexConverter.toHex(dos.digest());
        dos.close();
        return result;
    }

    protected String unquote(String s) {
        if (s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }
}

