/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.views;

import java.net.URL;
import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.guvnor.tools.Activator;
import org.guvnor.tools.Messages;
import org.guvnor.tools.utils.GuvnorMetadataUtils;
import org.guvnor.tools.utils.PlatformUtils;
import org.guvnor.tools.utils.ResourceHistorySorter;
import org.guvnor.tools.utils.webdav.IWebDavClient;
import org.guvnor.tools.utils.webdav.WebDavClientFactory;
import org.guvnor.tools.utils.webdav.WebDavException;
import org.guvnor.tools.utils.webdav.WebDavServerCache;
import org.guvnor.tools.views.ResourceHistoryContentProvider;
import org.guvnor.tools.views.ResourceHistoryLabelProvider;
import org.guvnor.tools.views.model.ResourceHistoryEntry;

public class ResourceHistoryView
extends ViewPart {
    private Label repositoryLabel;
    private Label resourceLabel;
    private TableViewer viewer;
    private Action showVersionAction;

    public void createPartControl(Composite parent) {
        Composite composite = PlatformUtils.createComposite(parent, 1);
        this.repositoryLabel = new Label(composite, 0);
        this.repositoryLabel.setText(Messages.getString("history.rep.label"));
        this.repositoryLabel.setLayoutData((Object)new GridData(768));
        this.resourceLabel = new Label(composite, 0);
        this.resourceLabel.setText(MessageFormat.format(Messages.getString("history.resource.label"), ""));
        this.resourceLabel.setLayoutData((Object)new GridData(768));
        this.viewer = new TableViewer(PlatformUtils.createResourceHistoryTable(composite));
        this.viewer.getTable().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)new ResourceHistoryContentProvider(new ResourceHistoryEntry[0]));
        this.viewer.setLabelProvider((IBaseLabelProvider)new ResourceHistoryLabelProvider());
        this.viewer.setSorter((ViewerSorter)new ResourceHistorySorter());
        this.viewer.setInput((Object)this.getViewSite());
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ResourceHistoryView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.showVersionAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ResourceHistoryView.this.showResourceVersionContents();
            }
        });
    }

    private void makeActions() {
        this.showVersionAction = new Action(){

            public void run() {
                ResourceHistoryView.this.showResourceVersionContents();
            }
        };
        this.showVersionAction.setText(Messages.getString("action.open"));
        this.showVersionAction.setToolTipText(Messages.getString("action.open.desc"));
        this.showVersionAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
    }

    private void showResourceVersionContents() {
        String repository = this.repositoryLabel.getToolTipText();
        String fullPath = this.resourceLabel.getToolTipText();
        ISelection selection = this.viewer.getSelection();
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (obj instanceof ResourceHistoryEntry) {
            ResourceHistoryEntry theEntry = (ResourceHistoryEntry)obj;
            try {
                String contents;
                block8: {
                    IWebDavClient client = WebDavServerCache.getWebDavClient(repository);
                    if (client == null) {
                        client = WebDavClientFactory.createClient(new URL(repository));
                        WebDavServerCache.cacheWebDavClient(repository, client);
                    }
                    contents = null;
                    try {
                        contents = client.getResourceVersionContents(fullPath, theEntry.getRevision());
                    }
                    catch (WebDavException wde) {
                        if (wde.getErrorCode() != 401) {
                            throw wde;
                        }
                        boolean retry = PlatformUtils.getInstance().authenticateForServer(repository, client);
                        if (!retry) break block8;
                        contents = client.getResourceVersionContents(fullPath, theEntry.getRevision());
                    }
                }
                if (contents != null) {
                    String editorTitle = null;
                    int pos = fullPath.lastIndexOf("/");
                    editorTitle = pos != -1 && pos + 1 < fullPath.length() ? fullPath.substring(pos + 1) : fullPath;
                    PlatformUtils.openEditor(contents, String.valueOf(editorTitle) + ", " + theEntry.getRevision());
                }
            }
            catch (Exception e) {
                Activator.getDefault().displayError(4, e.getMessage(), e, true);
            }
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void setEntries(String repository, String fullPath, Properties entryProps) {
        this.repositoryLabel.setText(String.valueOf(Messages.getString("history.rep.label")) + repository);
        this.repositoryLabel.setToolTipText(repository);
        this.resourceLabel.setText(MessageFormat.format(Messages.getString("history.resource.label"), fullPath.substring(repository.length())));
        this.resourceLabel.setToolTipText(fullPath);
        ResourceHistoryEntry[] entries = GuvnorMetadataUtils.parseHistoryProperties(entryProps);
        this.viewer.setContentProvider((IContentProvider)new ResourceHistoryContentProvider(entries));
        this.viewer.setInput((Object)this.getViewSite());
    }
}

