/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.http.client;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.webdav.client.Policy;
import org.eclipse.webdav.internal.kernel.utils.Assert;

public class RequestInputStream
extends InputStream {
    private long length = -1L;
    private long totalBytesRead = 0L;
    private InputStream is = null;
    private File file = null;
    private FileOutputStream fos = null;
    private boolean deleteFile = false;

    public RequestInputStream(byte[] b) {
        this.length = b.length;
        this.is = new ByteArrayInputStream(b);
    }

    public RequestInputStream(ByteArrayInputStream bais) {
        Assert.isNotNull(bais);
        this.length = bais.available();
        this.is = bais;
    }

    public RequestInputStream(File file) throws IOException {
        Assert.isNotNull(file);
        this.length = file.length();
        this.is = new FileInputStream(file);
        this.file = file;
    }

    public RequestInputStream(InputStream is, long length) throws IOException {
        Assert.isNotNull(is);
        Assert.isTrue(length >= -1L);
        this.length = length;
        this.is = is;
        this.file = File.createTempFile("ris", ".tmp");
        this.fos = new FileOutputStream(this.file);
        this.deleteFile = true;
    }

    public void close() throws IOException {
        this.is.close();
        if (this.fos != null) {
            this.fos.close();
        }
        if (this.deleteFile) {
            this.file.delete();
        }
    }

    public long length() {
        return this.length;
    }

    public int read() throws IOException {
        int b = this.is.read();
        if (b == -1) {
            if (this.length != -1L && this.totalBytesRead < this.length) {
                throw new IOException(Policy.bind("exception.unexpectedEndStream"));
            }
        } else {
            ++this.totalBytesRead;
            if (this.fos != null) {
                this.fos.write(b);
            }
        }
        return b;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = this.is.read(b, off, len);
        if (bytesRead == -1) {
            if (this.length != -1L && this.totalBytesRead < this.length) {
                throw new IOException(Policy.bind("exception.unexpectedEndStream"));
            }
        } else {
            this.totalBytesRead += (long)bytesRead;
            if (this.fos != null) {
                this.fos.write(b, off, len);
            }
        }
        return bytesRead;
    }

    public void reset() throws IOException {
        if (this.file == null) {
            ((ByteArrayInputStream)this.is).reset();
        } else {
            if (this.fos != null) {
                while (this.skip(4096L) > 0L) {
                }
                this.fos.close();
                this.fos = null;
                if (this.length == -1L) {
                    this.length = this.totalBytesRead;
                }
            }
            this.is.close();
            this.is = new FileInputStream(this.file);
        }
        this.totalBytesRead = 0L;
    }
}

