/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.kernel;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Date;
import org.eclipse.webdav.internal.kernel.ConditionFactor;
import org.eclipse.webdav.internal.kernel.Policy;
import org.eclipse.webdav.internal.kernel.WebDAVException;

public class EntityTag
extends ConditionFactor {
    private static int bcnt = 0;
    private static String basetime = Long.toHexString(new Date().getTime());
    private String eTag = null;
    private boolean weak = false;

    private EntityTag() {
    }

    public EntityTag(String tag) {
        this.eTag = tag;
    }

    public static ConditionFactor create(StreamTokenizer tokenizer) throws WebDAVException {
        EntityTag entityTag = new EntityTag();
        try {
            int token = tokenizer.ttype;
            if (token != 91) {
                throw new WebDAVException(400, Policy.bind("error.parseMissing", String.valueOf(token), "["));
            }
            token = tokenizer.nextToken();
            if (token != 34) {
                throw new WebDAVException(400, Policy.bind("error.parseMissingQuotedString", String.valueOf(token)));
            }
            entityTag.setETag(tokenizer.sval);
            token = tokenizer.nextToken();
            if (token != 93) {
                throw new WebDAVException(400, Policy.bind("error.parseMissing", String.valueOf(token), "]"));
            }
            token = tokenizer.nextToken();
        }
        catch (IOException iOException) {}
        return entityTag;
    }

    public boolean equals(Object etag) {
        return etag != null && etag instanceof EntityTag && this.getETag().equals(((EntityTag)etag).getETag());
    }

    public static EntityTag generateEntityTag() {
        String xx = String.valueOf(basetime) + ":" + Integer.toHexString(Thread.currentThread().hashCode());
        xx = String.valueOf(xx) + ":" + ++bcnt;
        return new EntityTag(xx);
    }

    public String getETag() {
        return this.eTag;
    }

    public boolean isWeak() {
        return this.weak;
    }

    public void setETag(String value) {
        this.eTag = value;
    }

    public void setWeak(boolean value) {
        this.weak = value;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.not()) {
            buffer.append("Not ");
        }
        if (this.isWeak()) {
            buffer.append("W/");
        }
        buffer.append("[\"");
        buffer.append(this.getETag());
        buffer.append("\"]");
        return buffer.toString();
    }
}

