/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.Assert;
import org.eclipse.webdav.dom.ElementEditor;
import org.eclipse.webdav.dom.MalformedElementException;
import org.eclipse.webdav.dom.QualifiedName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HrefSet
extends ElementEditor {
    public HrefSet(Element root, QualifiedName name) throws MalformedElementException {
        super(root, name.getLocalName());
        HrefSet.ensure("DAV:".equals(name.getQualifier()), Policy.bind("ensure.mustHaveDAVQualifier"));
    }

    public void addHref(String href) {
        String encodedHref = HrefSet.encodeHref(href);
        if (this.isDuplicate(encodedHref)) {
            return;
        }
        HrefSet.appendChild(this.root, "href", encodedHref);
    }

    public static HrefSet create(Document document, QualifiedName name) {
        Assert.isNotNull(document);
        Assert.isTrue(document.getOwnerDocument() == null);
        Assert.isNotNull(name);
        Assert.isTrue("DAV:".equals(name.getQualifier()));
        Element element = HrefSet.create(document, name.getLocalName());
        try {
            return new HrefSet(element, name);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
            return null;
        }
    }

    public Enumeration getHrefs() {
        Element firstHref = HrefSet.getFirstChild(this.root, "href");
        Enumeration e = new Enumeration(firstHref){
            Element currentHref;
            {
                this.currentHref = element;
            }

            @Override
            public boolean hasMoreElements() {
                return this.currentHref != null;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                String href = HrefSet.getFirstText(this.currentHref);
                this.currentHref = HrefSet.getNextSibling(this.currentHref, "href");
                return HrefSet.decodeHref(href);
            }
        };
        return e;
    }

    public void insertHrefAfter(String refHref, String newHref) {
        String refHrefEncoded = HrefSet.encodeHref(refHref);
        String newHrefEncoded = HrefSet.encodeHref(newHref);
        if (this.isDuplicate(newHrefEncoded)) {
            return;
        }
        Element child = HrefSet.getFirstChild(this.root, "href");
        while (child != null) {
            if (refHrefEncoded.equals(HrefSet.getFirstText(child))) {
                Element nextSibling = HrefSet.getNextSibling(child, "href");
                if (nextSibling == null) {
                    HrefSet.appendChild(this.root, "href", newHrefEncoded);
                } else {
                    HrefSet.insertBefore(nextSibling, "href", newHrefEncoded);
                }
                return;
            }
            child = HrefSet.getNextSibling(child, "href");
        }
        Assert.isTrue(false, Policy.bind("assert.noHrefRef"));
    }

    public void insertHrefBefore(String newHref, String refHref) {
        String refHrefEncoded = HrefSet.encodeHref(refHref);
        String newHrefEncoded = HrefSet.encodeHref(newHref);
        if (this.isDuplicate(newHrefEncoded)) {
            return;
        }
        Element child = HrefSet.getFirstChild(this.root, "href");
        while (child != null) {
            if (refHrefEncoded.equals(HrefSet.getFirstText(child))) {
                HrefSet.insertBefore(child, "href", newHrefEncoded);
                return;
            }
            child = HrefSet.getNextSibling(child, "href");
        }
        Assert.isTrue(false, Policy.bind("assert.noHrefRef"));
    }

    protected boolean isDuplicate(String encodedHref) {
        Element child = HrefSet.getFirstChild(this.root, "href");
        while (child != null) {
            if (encodedHref.equals(HrefSet.getFirstText(child))) {
                return true;
            }
            child = HrefSet.getNextSibling(child, "href");
        }
        return false;
    }

    public void removeHref(String href) {
        String encodedHref = HrefSet.encodeHref(href);
        Element child = HrefSet.getFirstChild(this.root, "href");
        while (child != null) {
            if (encodedHref.equals(HrefSet.getFirstText(child))) {
                this.root.removeChild(child);
                return;
            }
            child = HrefSet.getNextSibling(child, "href");
        }
    }
}

