/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.Assert;
import org.eclipse.webdav.dom.ElementEditor;
import org.eclipse.webdav.dom.MalformedElementException;
import org.eclipse.webdav.dom.Owner;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LockInfo
extends ElementEditor {
    public static final String[] childNames = new String[]{"lockscope", "locktype", "owner"};

    public LockInfo(Element root) throws MalformedElementException {
        super(root, "lockinfo");
    }

    public static LockInfo create(Document document) {
        Assert.isNotNull(document);
        Assert.isTrue(document.getOwnerDocument() == null);
        Element element = LockInfo.create(document, "lockinfo");
        Element locktype = LockInfo.appendChild(element, "locktype");
        LockInfo.appendChild(locktype, "write");
        LockInfo result = null;
        try {
            result = new LockInfo(element);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
        }
        return result;
    }

    public Owner getOwner() throws MalformedElementException {
        Element owner = LockInfo.getLastChild(this.root, "owner");
        if (owner == null) {
            return null;
        }
        return new Owner(owner);
    }

    public boolean isShared() throws MalformedElementException {
        Element lockscope = LockInfo.getFirstChild(this.root, "lockscope");
        LockInfo.ensureNotNull(Policy.bind("ensure.missingLockscopeElmt"), lockscope);
        String[] names = new String[]{"shared", "exclusive"};
        Element sharedOrExclusive = LockInfo.getFirstChild(lockscope, names);
        LockInfo.ensureNotNull(Policy.bind("ensure.missingSharedOrExclusiveElmt"), sharedOrExclusive);
        boolean isShared = LockInfo.isDAVElement(sharedOrExclusive, "shared");
        LockInfo.ensure(LockInfo.getNextSibling(sharedOrExclusive, names) == null, Policy.bind("ensure.conflictingSharedOrExclusiveElmt"));
        return isShared;
    }

    public void setIsShared(boolean isShared) {
        Element lockscope = LockInfo.setChild(this.root, "lockscope", childNames, true);
        if (isShared) {
            LockInfo.appendChild(lockscope, "shared");
        } else {
            LockInfo.appendChild(lockscope, "exclusive");
        }
    }

    public Owner setOwner() {
        Element owner = LockInfo.setChild(this.root, "owner", childNames, false);
        Owner result = null;
        try {
            result = new Owner(owner);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
        }
        return result;
    }
}

