/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.http.client;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.webdav.client.Policy;
import org.eclipse.webdav.internal.kernel.utils.Assert;

public class ContentType {
    private String contentType;
    private int position;
    private boolean foundDelim;
    private String type;
    private String subtype;
    private Hashtable parameters = new Hashtable(5);

    public ContentType(String contentType) throws IllegalArgumentException {
        Assert.isNotNull(contentType);
        this.contentType = contentType;
        this.position = 0;
        this.parse();
    }

    private void checkPosition() throws IllegalArgumentException {
        if (this.position >= this.contentType.length()) {
            this.illegalArgument();
        }
    }

    public Enumeration getAttributes() {
        return this.parameters.keys();
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String getType() {
        return this.type;
    }

    public String getValue(String attribute) {
        return (String)this.parameters.get(attribute);
    }

    private void illegalArgument() throws IllegalArgumentException {
        throw new IllegalArgumentException(Policy.bind("exception.malformedContentType", this.contentType));
    }

    private String nextToken(char delim, boolean trim) throws IllegalArgumentException {
        int start;
        int end = start = this.position;
        boolean done = false;
        boolean trimming = false;
        while (!done) {
            if (this.position == this.contentType.length()) {
                done = true;
                this.foundDelim = false;
                continue;
            }
            char c = this.contentType.charAt(this.position);
            if (Character.isWhitespace(c)) {
                if (trim) {
                    trimming = true;
                } else {
                    this.illegalArgument();
                }
            } else if (c == delim) {
                done = true;
                this.foundDelim = true;
            } else {
                if (trimming) {
                    this.illegalArgument();
                }
                end = this.position + 1;
            }
            ++this.position;
        }
        return this.contentType.substring(start, end);
    }

    private void parse() throws IllegalArgumentException {
        this.checkPosition();
        this.skipWhiteSpace();
        this.checkPosition();
        this.type = this.nextToken('/', false);
        this.checkPosition();
        this.subtype = this.nextToken(';', true);
        this.skipWhiteSpace();
        if (this.foundDelim) {
            this.checkPosition();
        }
        while (this.position < this.contentType.length()) {
            String attribute = this.nextToken('=', false);
            this.checkPosition();
            String value = this.nextToken(';', true);
            if (value.startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            this.skipWhiteSpace();
            if (this.foundDelim) {
                this.checkPosition();
            }
            this.parameters.put(attribute, value);
        }
    }

    private void skipWhiteSpace() {
        while (this.position < this.contentType.length() && Character.isWhitespace(this.contentType.charAt(this.position))) {
            ++this.position;
        }
    }
}

