/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.kernel.utils;

import org.eclipse.webdav.internal.kernel.Policy;
import org.eclipse.webdav.internal.kernel.utils.AssertionFailedException;

public class Assert {
    private Assert() {
    }

    public static boolean isLegal(boolean expression) {
        return Assert.isLegal(expression, "");
    }

    public static boolean isLegal(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
        return expression;
    }

    public static void isNotNull(Object o) {
        Assert.isNotNull(o, "");
    }

    public static void isNotNull(Object o, String message) {
        if (o == null) {
            throw new AssertionFailedException(Policy.bind("assert.null", message));
        }
    }

    public static boolean isTrue(boolean expression) {
        return Assert.isTrue(expression, "");
    }

    public static boolean isTrue(boolean expression, String message) {
        if (!expression) {
            throw new AssertionFailedException(Policy.bind("assert.fail", message));
        }
        return expression;
    }
}

