/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.views.model;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.views.properties.IPropertySource;
import org.guvnor.tools.GuvnorRepository;
import org.guvnor.tools.utils.webdav.ResourceProperties;
import org.guvnor.tools.views.model.TreeParent;
import org.guvnor.tools.views.model.TreePropertyProvider;

public class TreeObject
implements IAdaptable {
    private GuvnorRepository theRep;
    private String name;
    private Type nodeType;
    private TreeParent parent;
    private ResourceProperties props;
    private TreePropertyProvider propProvider;

    public TreeObject(String name, Type nodeType) {
        this.name = name;
        this.nodeType = nodeType;
    }

    public String getName() {
        return this.name;
    }

    public Type getNodeType() {
        return this.nodeType;
    }

    public void setParent(TreeParent parent) {
        this.parent = parent;
    }

    public TreeParent getParent() {
        return this.parent;
    }

    public String toString() {
        return this.getName();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySource.class) {
            if (this.propProvider == null) {
                this.propProvider = new TreePropertyProvider(this);
            }
            return this.propProvider;
        }
        return null;
    }

    public ResourceProperties getResourceProps() {
        return this.props;
    }

    public void setResourceProps(ResourceProperties props) {
        this.props = props;
    }

    public void setGuvnorRepository(GuvnorRepository theRep) {
        this.theRep = theRep;
    }

    public GuvnorRepository getGuvnorRepository() {
        return this.theRep;
    }

    public String getFullPath() {
        if (this.props.getBase().trim().length() > 0) {
            if (this.props.getBase().endsWith("/")) {
                return String.valueOf(this.props.getBase()) + this.getName();
            }
            return String.valueOf(this.props.getBase()) + "/" + this.getName();
        }
        return this.getName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        NONE,
        REPOSITORY,
        GLOBALS,
        PACKAGES,
        SNAPSHOTS,
        PACKAGE,
        SNAPSHOT_PACKAGE,
        SNAPSHOT,
        RESOURCE;

    }
}

