/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.wizards;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.guvnor.tools.Activator;
import org.guvnor.tools.Messages;
import org.guvnor.tools.utils.GuvnorMetadataUtils;
import org.guvnor.tools.utils.PlatformUtils;
import org.guvnor.tools.wizards.GuvWizardModel;
import org.guvnor.tools.wizards.GuvnorMainConfigPage;
import org.guvnor.tools.wizards.IGuvnorWizard;
import org.guvnor.tools.wizards.SelectGuvnorFolderPage;
import org.guvnor.tools.wizards.SelectGuvnorRepPage;

public class AddResourceWizard
extends Wizard
implements INewWizard,
IGuvnorWizard {
    private SelectGuvnorRepPage selectRepPage;
    private GuvnorMainConfigPage mainConfigPage;
    private SelectGuvnorFolderPage selectFolderPage;
    private IStructuredSelection selectedItems;
    private GuvWizardModel model = new GuvWizardModel();

    @Override
    public GuvWizardModel getModel() {
        return this.model;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selectedItems = selection;
    }

    public void addPages() {
        this.selectRepPage = new SelectGuvnorRepPage("select_rep_page", Messages.getString("select.guvnor.rep.location"), Activator.getImageDescriptor("guvnor_rep_wizban.gif"));
        this.selectRepPage.setDescription(Messages.getString("select.guvnor.rep.location.desc"));
        super.addPage((IWizardPage)this.selectRepPage);
        this.mainConfigPage = new GuvnorMainConfigPage("config_page", Messages.getString("new.guvnor.rep.loc"), Activator.getImageDescriptor("guvnor_rep_wizban.gif"));
        this.mainConfigPage.setDescription(Messages.getString("new.guvnor.rep.loc.desc"));
        super.addPage((IWizardPage)this.mainConfigPage);
        this.selectFolderPage = new SelectGuvnorFolderPage("select_folder_page", Messages.getString("select.folder"), Activator.getImageDescriptor("guvnor_rep_wizban.gif"));
        this.selectFolderPage.setDescription(Messages.getString("select.folder.desc"));
        super.addPage((IWizardPage)this.selectFolderPage);
        super.addPages();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page.getName().equals("select_rep_page")) {
            if (this.model.shouldCreateNewRep()) {
                return this.mainConfigPage;
            }
            return this.selectFolderPage;
        }
        if (page.getName().equals("config_page")) {
            return this.selectFolderPage;
        }
        return null;
    }

    private void setDuplicateFileError(IFile selectedFile) {
        this.selectFolderPage.setErrorMessage(MessageFormat.format(Messages.getString("already.exists.folder"), selectedFile.getName(), this.model.getTargetLocation()));
        this.model.setTargetLocation(null);
        super.getContainer().updateButtons();
    }

    private boolean processSelectedFile(IFile selectedFile) {
        boolean res = GuvnorMetadataUtils.addResourceToGuvnor(this.model.getRepLocation(), this.model.getTargetLocation(), selectedFile);
        if (!res) {
            this.setDuplicateFileError(selectedFile);
        }
        return res;
    }

    public boolean performFinish() {
        boolean res = true;
        assert (this.selectedItems != null);
        for (Object oneItem : this.selectedItems) {
            if (oneItem instanceof IFile && !(res = this.processSelectedFile((IFile)oneItem))) break;
        }
        PlatformUtils.updateDecoration();
        return res;
    }

    public boolean canFinish() {
        return this.model.getRepLocation() != null && this.model.getTargetLocation() != null;
    }
}

