/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.guvnor.tools.Activator;
import org.guvnor.tools.preferences.GuvnorPreferencePage;
import org.guvnor.tools.utils.GuvnorMetadataProps;
import org.guvnor.tools.utils.GuvnorMetadataUtils;

public class GuvnorDecorator
implements ILightweightLabelDecorator {
    public static final String DECORATOR_ID = "org.guvnor.tools.decorator";

    private boolean isGuvnorResource(Object element) {
        if (element instanceof IResource) {
            return GuvnorMetadataUtils.findGuvnorMetadata((IResource)element) != null;
        }
        return false;
    }

    private void decorateResource(IResource resource, IDecoration decoration) {
        try {
            if (resource instanceof IFile) {
                if (!((IFile)resource).exists()) {
                    return;
                }
                this.addGuvnorOverlay(decoration);
                this.addChangeIndicator(resource, decoration);
                this.addResourceDetails(resource, decoration);
            }
        }
        catch (Exception e) {
            Activator.getDefault().writeLog(4, e.getMessage(), e);
        }
    }

    private void addGuvnorOverlay(IDecoration decoration) {
        int overlayLoc = GuvnorPreferencePage.getOverlayLocationPref();
        if (overlayLoc != 4) {
            decoration.addOverlay(Activator.getImageDescriptor("guvnor_controlled.gif"), overlayLoc);
        }
    }

    private void addResourceDetails(IResource resource, IDecoration decoration) throws Exception {
        GuvnorMetadataProps props = GuvnorMetadataUtils.getGuvnorMetadata(resource);
        if (props.getVersion() != null) {
            boolean showRevision = GuvnorPreferencePage.shouldShowRevision();
            boolean showDateTime = GuvnorPreferencePage.shouldShowTimeDateStamp();
            if (showRevision || showDateTime) {
                decoration.addSuffix(" ");
            }
            if (showRevision) {
                decoration.addSuffix(props.getRevision());
            }
            if (showDateTime) {
                if (showRevision) {
                    decoration.addSuffix(", " + props.getVersion());
                } else {
                    decoration.addSuffix(props.getVersion());
                }
            }
        }
    }

    private void addChangeIndicator(IResource resource, IDecoration decoration) throws CoreException {
        if (!GuvnorMetadataUtils.isGuvnorResourceCurrent(resource) && GuvnorPreferencePage.shouldShowChangeIndicator()) {
            decoration.addSuffix(" >");
        }
    }

    public void decorate(Object element, IDecoration decoration) {
        if (this.isGuvnorResource(element)) {
            if (element instanceof IResource) {
                this.decorateResource((IResource)element, decoration);
            } else {
                Activator.getDefault().writeLog(4, "Called to decorate unknown: " + element.getClass().toString(), new Exception());
            }
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

