/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.actions;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.guvnor.tools.Activator;
import org.guvnor.tools.utils.ActionUtils;
import org.guvnor.tools.utils.GuvnorMetadataUtils;
import org.guvnor.tools.utils.PlatformUtils;

public class DisconnectAction
implements IObjectActionDelegate {
    private IStructuredSelection selectedItems;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.selectedItems == null) {
            return;
        }
        this.disconnect(this.selectedItems);
        PlatformUtils.updateDecoration();
    }

    public void disconnect(IStructuredSelection files) {
        ArrayList<IFile> toDelete = new ArrayList<IFile>();
        for (Object oneSelection : files) {
            IFile mdFile;
            if (!(oneSelection instanceof IFile) || (mdFile = GuvnorMetadataUtils.findGuvnorMetadata((IResource)((IFile)oneSelection))) == null) continue;
            toDelete.add(mdFile);
        }
        try {
            IFile[] mdFiles = new IFile[toDelete.size()];
            toDelete.toArray(mdFiles);
            IWorkspace ws = Activator.getDefault().getWorkspace();
            ws.delete((IResource[])mdFiles, true, null);
        }
        catch (CoreException e) {
            Activator.getDefault().displayError(4, e.getMessage(), e, true);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean validResourceSet = ActionUtils.checkResourceSet(selection, true);
        if (validResourceSet) {
            action.setEnabled(true);
            this.selectedItems = (IStructuredSelection)selection;
        } else {
            action.setEnabled(false);
            this.selectedItems = null;
        }
    }
}

