/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.runtime;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.kie.eclipse.Activator;
import org.kie.eclipse.runtime.AbstractRuntime;
import org.kie.eclipse.runtime.DefaultRuntimeRecognizer;
import org.kie.eclipse.runtime.IRuntime;
import org.kie.eclipse.runtime.IRuntimeManager;
import org.kie.eclipse.runtime.IRuntimeManagerListener;
import org.kie.eclipse.runtime.IRuntimeRecognizer;

public abstract class AbstractRuntimeManager
implements IRuntimeManager {
    private ArrayList<IRuntimeManagerListener> listeners = new ArrayList();

    @Override
    public void addListener(IRuntimeManagerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IRuntimeManagerListener listener) {
        this.listeners.remove(listener);
    }

    public void addRuntime(IRuntime rt) {
        ArrayList<IRuntime> list = new ArrayList<IRuntime>();
        list.addAll(Arrays.asList(this.getConfiguredRuntimes()));
        list.add(rt);
        this.setRuntimesInternal(list.toArray(new IRuntime[list.size()]));
        this.fireRuntimeAdded(rt);
    }

    public void removeRuntime(IRuntime rt) {
        ArrayList<IRuntime> list = new ArrayList<IRuntime>();
        list.addAll(Arrays.asList(this.getConfiguredRuntimes()));
        list.remove(rt);
        this.setRuntimesInternal(list.toArray(new IRuntime[list.size()]));
        this.fireRuntimeRemoved(rt);
    }

    private void fireRuntimeAdded(IRuntime rt) {
        Iterator<IRuntimeManagerListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().runtimeAdded(rt);
        }
    }

    private void fireRuntimeRemoved(IRuntime rt) {
        Iterator<IRuntimeManagerListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().runtimeRemoved(rt);
        }
    }

    private void fireRuntimesChanged() {
        Iterator<IRuntimeManagerListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().runtimesChanged(this.getConfiguredRuntimes());
        }
    }

    @Override
    public IRuntime getEffectiveRuntime(IRuntime selectedRuntime, boolean useDefault) {
        if (useDefault) {
            return this.getDefaultRuntime();
        }
        return selectedRuntime;
    }

    protected String createStringFromRuntimes(IRuntime[] runtimes) {
        String result = "";
        IRuntime[] iRuntimeArray = runtimes;
        int n = runtimes.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime runtime = iRuntimeArray[n2];
            result = String.valueOf(result) + runtime.getName() + "#" + runtime.getPath() + "#" + runtime.isDefault() + "# ";
            result = String.valueOf(result) + runtime.getProduct() + "#";
            result = String.valueOf(result) + runtime.getVersion() + "#";
            if (runtime.getJars() != null) {
                String[] stringArray = runtime.getJars();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String jar = stringArray[n4];
                    result = String.valueOf(result) + jar + ";";
                    ++n4;
                }
            }
            result = String.valueOf(result) + "###";
            ++n2;
        }
        return result;
    }

    protected IRuntime[] createRuntimesFromString(String s) {
        ArrayList<IRuntime> result = new ArrayList<IRuntime>();
        if (s != null && !"".equals(s)) {
            String[] runtimeStrings;
            String[] stringArray = runtimeStrings = s.split("###");
            int n = runtimeStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String runtimeString = stringArray[n2];
                String[] properties = runtimeString.split("#");
                if (properties.length >= 2) {
                    IRuntime runtime = this.createNewRuntime();
                    runtime.setName(properties[0]);
                    String location = properties[1];
                    File file = new File(location);
                    if (file.exists()) {
                        runtime.setPath(location);
                        runtime.setDefault("true".equals(properties[2]));
                        if (properties.length > 3) {
                            int index = 3;
                            if (properties.length > 5) {
                                runtime.setProduct(properties[index++]);
                                runtime.setVersion(properties[index++]);
                            }
                            ArrayList<String> list = new ArrayList<String>();
                            String[] jars = properties[index].split(";");
                            index = 0;
                            while (index < jars.length) {
                                String jar = jars[index++];
                                if ((jar = jar.trim()).length() <= 0) continue;
                                list.add(jar);
                            }
                            runtime.setJars(list.toArray(new String[list.size()]));
                        }
                        result.add(runtime);
                    }
                    Collections.sort(result);
                }
                ++n2;
            }
        }
        return result.toArray(new IRuntime[result.size()]);
    }

    @Override
    public IRuntime[] getConfiguredRuntimes() {
        String runtimesString = this.getPreferenceStore().getString(this.getRuntimePreferenceKey());
        if (runtimesString != null) {
            IRuntime[] runtimes = this.createRuntimesFromString(runtimesString);
            boolean rebuild = false;
            IRuntime[] iRuntimeArray = runtimes;
            int n = runtimes.length;
            int n2 = 0;
            while (n2 < n) {
                IRuntime rt = iRuntimeArray[n2];
                if (rt.getJars() == null || rt.getJars().length == 0) {
                    rebuild = true;
                    this.recognizeJars(rt);
                }
                ++n2;
            }
            if (rebuild) {
                this.setRuntimes(runtimes);
            }
            return runtimes;
        }
        return new IRuntime[0];
    }

    @Override
    public void setRuntimes(IRuntime[] runtimes) {
        this.setRuntimesInternal(runtimes);
        this.fireRuntimesChanged();
    }

    private void setRuntimesInternal(IRuntime[] runtimes) {
        ArrayList<IRuntime> uniqueRuntimes = new ArrayList<IRuntime>();
        IRuntime[] iRuntimeArray = runtimes;
        int n = runtimes.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime rt = iRuntimeArray[n2];
            if (!uniqueRuntimes.contains(rt)) {
                uniqueRuntimes.add(rt);
            }
            ++n2;
        }
        String s = this.createStringFromRuntimes(uniqueRuntimes.toArray(new IRuntime[uniqueRuntimes.size()]));
        this.getPreferenceStore().setValue(this.getRuntimePreferenceKey(), s);
    }

    public IRuntime getRuntime(String name) {
        IRuntime[] runtimes;
        IRuntime[] iRuntimeArray = runtimes = this.getConfiguredRuntimes();
        int n = runtimes.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime runtime = iRuntimeArray[n2];
            if (runtime.getName().equals(name)) {
                return runtime;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IRuntime getDefaultRuntime() {
        IRuntime[] runtimes;
        IRuntime[] iRuntimeArray = runtimes = this.getConfiguredRuntimes();
        int n = runtimes.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime runtime = iRuntimeArray[n2];
            if (runtime.isDefault()) {
                return runtime;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void setRuntime(IRuntime runtime, IProject project, IProgressMonitor monitor) throws CoreException {
        if (runtime != null) {
            IFile file = project.getFile(".settings/" + this.getSettingsFilename());
            String runtimeString = "<runtime>" + runtime.getName() + "</runtime>";
            if (!file.exists()) {
                IFolder folder = project.getProject().getFolder(".settings");
                if (!folder.exists()) {
                    folder.create(true, true, null);
                }
                file.create((InputStream)new ByteArrayInputStream(runtimeString.getBytes()), true, null);
            } else {
                file.setContents((InputStream)new ByteArrayInputStream(runtimeString.getBytes()), true, false, null);
            }
        }
    }

    @Override
    public IRuntime getRuntime(IProject project) {
        try {
            BufferedReader reader;
            String location;
            IFile file = project.getFile(".settings/" + this.getSettingsFilename());
            if (file.exists() && (location = (reader = new BufferedReader(new InputStreamReader(file.getContents()))).readLine()).startsWith("<runtime>") && location.endsWith("</runtime>")) {
                String runtimeName = location.substring(9, location.length() - 10);
                return this.getRuntime(runtimeName);
            }
        }
        catch (Exception e) {
            this.logException(e);
        }
        return this.getDefaultRuntime();
    }

    public String[] getRuntimeJars(IProject project) {
        IRuntime runtime = this.getRuntime(project);
        if (runtime == null) {
            return null;
        }
        if (runtime.getJars() == null || runtime.getJars().length == 0) {
            this.recognizeJars(runtime);
        }
        return runtime.getJars();
    }

    @Override
    public int recognizeJars(IRuntime runtime) {
        String path = runtime.getPath();
        if (path != null) {
            IRuntimeRecognizer recognizer = null;
            String[] jars = null;
            IRuntimeRecognizer[] iRuntimeRecognizerArray = this.getRuntimeRecognizers();
            int n = iRuntimeRecognizerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IRuntimeRecognizer r = iRuntimeRecognizerArray[n2];
                jars = r.recognizeJars(path);
                if (jars != null && jars.length > 0) {
                    recognizer = r;
                    break;
                }
                ++n2;
            }
            if (recognizer == null) {
                recognizer = new DefaultRuntimeRecognizer();
                jars = recognizer.recognizeJars(path);
            }
            if (jars != null && jars.length > 0) {
                AbstractRuntime.Version version = runtime.getVersion();
                String product = runtime.getProduct();
                List<AbstractRuntime.Version> versions = recognizer.getProducts().get(product);
                if (versions != null && versions.size() > 0) {
                    if (!version.isValid() || !versions.contains(version)) {
                        Collections.sort(versions, Collections.reverseOrder());
                        if (versions.size() > 0) {
                            runtime.setVersion(versions.get(0).toString());
                        }
                    }
                    runtime.setJars(jars);
                    if (versions.size() > 1) {
                        Activator.logError("The Runtime at '" + runtime.getPath() + "' " + "may have more than one version of installed jar files " + "for the " + runtime.getProduct() + " product.", new Throwable());
                    }
                }
                return jars.length;
            }
        }
        return 0;
    }

    public abstract String getRuntimeWorkspaceLocation();

    public abstract String getRuntimePreferenceKey();

    public abstract IRuntimeRecognizer[] getRuntimeRecognizers();

    @Override
    public abstract String getSettingsFilename();

    public abstract String getBundleSymbolicName();

    @Override
    public abstract IRuntime createNewRuntime();

    public abstract void logException(Throwable var1);

    public abstract IPreferenceStore getPreferenceStore();
}

