/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.runtime;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import org.kie.eclipse.runtime.AbstractRuntime;
import org.kie.eclipse.runtime.IRuntimeRecognizer;

public abstract class AbstractRuntimeRecognizer
implements IRuntimeRecognizer {
    List<String> fileList = new ArrayList<String>();
    Hashtable<String, List<AbstractRuntime.Version>> products = new Hashtable();

    protected void clearFiles() {
        this.fileList.clear();
        this.products.clear();
    }

    protected void addFile(File file) {
        block23: {
            this.fileList.add(file.getAbsolutePath());
            String product = null;
            String name = file.getName();
            if (name.startsWith("drools-")) {
                product = "drools";
            } else if (name.startsWith("jbpm-")) {
                product = "jbpm";
            }
            if (product != null && file.getName().endsWith(".jar")) {
                JarFile jar = null;
                try {
                    try {
                        String versionPart;
                        jar = new JarFile(file);
                        AbstractRuntime.Version version = null;
                        for (Map.Entry<Object, Object> a : jar.getManifest().getMainAttributes().entrySet()) {
                            if (!"Bundle-Version".equals(a.getKey().toString())) continue;
                            version = new AbstractRuntime.Version((String)a.getValue());
                            break;
                        }
                        if (version == null) {
                            for (Map.Entry<Object, Object> a : jar.getManifest().getMainAttributes().entrySet()) {
                                if (!"Implementation-Version".equals(a.getKey().toString())) continue;
                                version = new AbstractRuntime.Version((String)a.getValue());
                                break;
                            }
                        }
                        if (version == null && AbstractRuntime.Version.validate(versionPart = name.replaceFirst(".*([0-9]+\\.[0-9]+\\.[0-9]+\\..*)", "$1").replace(".jar", "")) == null) {
                            version = new AbstractRuntime.Version(versionPart);
                        }
                        if (version == null) break block23;
                        List<AbstractRuntime.Version> productVersions = this.products.get(product);
                        if (productVersions != null) {
                            if (!productVersions.contains(version)) {
                                productVersions.add(version);
                            }
                            break block23;
                        }
                        productVersions = new ArrayList<AbstractRuntime.Version>();
                        productVersions.add(version);
                        this.products.put(product, productVersions);
                    }
                    catch (Exception exception) {
                        try {
                            if (jar != null) {
                                jar.close();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                finally {
                    try {
                        if (jar != null) {
                            jar.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    protected String[] getFiles() {
        return this.fileList.toArray(new String[this.fileList.size()]);
    }

    @Override
    public Hashtable<String, List<AbstractRuntime.Version>> getProducts() {
        return this.products;
    }
}

