/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.preferences;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.internal.ui.preferences.PropertyAndPreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.kie.eclipse.runtime.IRuntime;
import org.kie.eclipse.runtime.IRuntimeManager;

public abstract class AbstractProjectPreferencePage
extends PropertyAndPreferencePage {
    private IRuntimeManager runtimeManager;
    private Combo runtimeCombo;

    public AbstractProjectPreferencePage() {
        this.setTitle("Project Preferences");
        this.runtimeManager = this.getRuntimeManager();
    }

    protected Control createPreferenceContent(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText("Runtime:");
        this.runtimeCombo = new Combo(composite, 8);
        IRuntime[] runtimes = this.runtimeManager.getConfiguredRuntimes();
        int selection = -1;
        IRuntime currentRuntime = this.runtimeManager.getRuntime(this.getProject());
        int i = 0;
        while (i < runtimes.length) {
            this.runtimeCombo.add(runtimes[i].getName());
            if (runtimes[i].equals(currentRuntime)) {
                selection = i;
            }
            ++i;
        }
        if (selection != -1) {
            this.runtimeCombo.select(selection);
        } else if (runtimes.length > 0) {
            this.runtimeCombo.select(0);
        }
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.runtimeCombo.setLayoutData((Object)gridData);
        return composite;
    }

    protected boolean hasProjectSpecificOptions(IProject project) {
        String path = ".settings/" + this.runtimeManager.getSettingsFilename();
        return project.getFile(path).exists();
    }

    public boolean performOk() {
        try {
            String path = ".settings/" + this.runtimeManager.getSettingsFilename();
            IFile file = this.getProject().getFile(path);
            if (this.useProjectSettings()) {
                String runtime = "<runtime>" + this.runtimeCombo.getItem(this.runtimeCombo.getSelectionIndex()) + "</runtime>";
                if (!file.exists()) {
                    IFolder folder = this.getProject().getFolder(".settings");
                    if (!folder.exists()) {
                        folder.create(true, true, null);
                    }
                    file.create((InputStream)new ByteArrayInputStream(runtime.getBytes()), true, null);
                } else {
                    file.setContents((InputStream)new ByteArrayInputStream(runtime.getBytes()), true, false, null);
                }
            } else if (file.exists()) {
                file.delete(true, null);
            }
            this.getProject().close(null);
            this.getProject().open(null);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
        return super.performOk();
    }

    protected abstract IRuntimeManager getRuntimeManager();

    protected abstract String getPreferencePageID();

    protected abstract String getPropertyPageID();
}

