/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.preferences;

import java.io.File;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.kie.eclipse.runtime.AbstractRuntime;
import org.kie.eclipse.runtime.IRuntime;
import org.kie.eclipse.runtime.IRuntimeManager;

public abstract class AbstractRuntimeDialog
extends Dialog {
    private IRuntime runtime;
    private Text nameText;
    private Text pathText;
    private Text versionText;
    private Text errorMessageText;
    private List<IRuntime> runtimes;
    private boolean editMode;
    private Listener textModifyListener = new Listener(){

        public void handleEvent(Event e) {
            AbstractRuntimeDialog.this.validate(e.widget);
        }
    };

    public AbstractRuntimeDialog(Shell parent, List<IRuntime> runtimes) {
        super(parent);
        this.setBlockOnOpen(true);
        this.runtimes = runtimes;
        this.runtime = this.getRuntimeManager().createNewRuntime();
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite.setLayout((Layout)new GridLayout(3, false));
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText("Name:");
        nameLabel.setLayoutData((Object)new GridData(3, 2, false, false, 1, 1));
        this.nameText = new Text(composite, 2052);
        this.nameText.setText(this.editMode ? this.runtime.getName() : "");
        this.nameText.addListener(24, this.textModifyListener);
        this.nameText.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        Label pathLabel = new Label(composite, 0);
        pathLabel.setText("Path:");
        pathLabel.setLayoutData((Object)new GridData(3, 2, false, false, 1, 1));
        this.pathText = new Text(composite, 2052);
        this.pathText.setText(this.editMode ? this.runtime.getPath() : "");
        this.pathText.addListener(24, this.textModifyListener);
        this.pathText.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        Button selectButton = new Button(composite, 16392);
        selectButton.setText("Browse...");
        selectButton.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        selectButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractRuntimeDialog.this.browse();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label versionLabel = new Label(composite, 0);
        versionLabel.setText("Version:");
        versionLabel.setLayoutData((Object)new GridData(3, 2, false, false, 1, 1));
        this.versionText = new Text(composite, 2052);
        this.versionText.setText(this.editMode ? this.runtime.getVersion().toString() : "");
        this.versionText.addListener(24, this.textModifyListener);
        this.versionText.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        this.errorMessageText = new Text(composite, 72);
        this.errorMessageText.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        this.errorMessageText.setBackground(this.errorMessageText.getDisplay().getSystemColor(22));
        this.validate(null);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.editMode) {
            newShell.setText("Edit Runtime");
        } else {
            newShell.setText("Add Runtime");
        }
    }

    protected Point getInitialSize() {
        Point p = super.getInitialSize();
        return new Point(500, p.y);
    }

    public void setRuntime(IRuntime runtime) {
        if (runtime != null) {
            this.runtime = runtime;
            this.editMode = true;
        }
    }

    private void validate(Widget widget) {
        String version;
        String error;
        this.setErrorMessage(null);
        if (widget == this.nameText || widget == null) {
            String name = this.nameText.getText();
            if (name == null || "".equals(name.trim())) {
                this.setErrorMessage("Name is required");
                return;
            }
            if (!name.equals(this.runtime.getName())) {
                for (IRuntime runtime : this.runtimes) {
                    if (!name.equals(runtime.getName())) continue;
                    this.setErrorMessage("The Runtime \"" + name + "\" is already registered");
                    return;
                }
            }
        }
        if (widget == this.pathText || widget == null) {
            String location = this.pathText.getText();
            if (location != null && !location.isEmpty()) {
                int jarCount;
                File file = new File(location);
                if (!file.exists() || !file.isDirectory()) {
                    this.setErrorMessage("Path does not exist or is not a directory");
                    return;
                }
                IRuntime r = this.getRuntimeManager().createNewRuntime();
                r.setVersion(null);
                r.setPath(location);
                this.getRuntimeManager().recognizeJars(r);
                int n = jarCount = r.getJars() == null ? 0 : r.getJars().length;
                if (jarCount > 0) {
                    if (this.versionText.getText().isEmpty()) {
                        this.versionText.setText(r.getVersion().toString());
                        widget = this.versionText;
                    }
                    if (this.nameText.getText().isEmpty()) {
                        this.nameText.setText(String.valueOf(r.getName()) + " " + r.getVersion().toString());
                        this.validate((Widget)this.nameText);
                    }
                    if (this.editMode) {
                        r.setVersion(this.runtime.getVersion().toString());
                    }
                    this.runtime = r;
                } else {
                    this.setErrorMessage("The given Path does not contain any " + r.getName() + " Runtime jars");
                }
            } else {
                this.setErrorMessage("Path is required");
                return;
            }
        }
        if ((widget == this.versionText || widget == null) && (error = AbstractRuntime.Version.validate(version = this.versionText.getText())) != null) {
            this.setErrorMessage(error);
        }
    }

    private void browse() {
        String selectedDirectory = null;
        String dirName = this.pathText.getText();
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setMessage("Select the Runtime directory.");
        dialog.setFilterPath(dirName);
        selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            this.pathText.setText(selectedDirectory);
        }
    }

    public IRuntime getResult() {
        return this.runtime;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.runtime.setName(this.nameText.getText());
            this.runtime.setPath(this.pathText.getText());
            if (this.runtime.getJars() == null || this.runtime.getJars().length == 0) {
                this.getRuntimeManager().recognizeJars(this.runtime);
                if (this.runtime.getJars() == null || this.runtime.getJars().length == 0) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Invalid Runtime Directory", (String)("No Runtime was found in the specified path " + this.pathText.getText()));
                    return;
                }
            }
            this.runtime.setVersion(this.versionText.getText());
        } else {
            this.runtime = null;
        }
        super.buttonPressed(buttonId);
    }

    public void setErrorMessage(String errorMessage) {
        if (this.errorMessageText != null && !this.errorMessageText.isDisposed()) {
            this.errorMessageText.setText(errorMessage == null ? " \n " : errorMessage);
            boolean hasError = errorMessage != null && StringConverter.removeWhiteSpaces((String)errorMessage).length() > 0;
            this.errorMessageText.setEnabled(hasError);
            this.errorMessageText.setVisible(hasError);
            this.errorMessageText.getParent().layout();
            this.errorMessageText.getParent().update();
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(errorMessage == null);
            }
        }
    }

    protected abstract IRuntimeManager getRuntimeManager();
}

