/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.server;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jgit.lib.Repository;
import org.kie.eclipse.server.IKieProjectHandler;
import org.kie.eclipse.server.IKieRepositoryHandler;
import org.kie.eclipse.server.IKieResourceHandler;
import org.kie.eclipse.server.KieResourceHandler;
import org.kie.eclipse.utils.GitUtils;

public class KieProjectHandler
extends KieResourceHandler
implements IKieProjectHandler {
    IProject project;
    File directory;

    public KieProjectHandler(IKieRepositoryHandler repository, String name) {
        super(repository, name);
    }

    @Override
    public Object getResource() {
        return this.project;
    }

    @Override
    public void setResource(Object resource) {
        if (resource == null || resource instanceof IProject) {
            this.project = (IProject)resource;
        }
    }

    @Override
    public Object load() {
        Repository repository;
        if (this.project == null && (repository = (Repository)this.parent.load()) != null) {
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.getName().equals(this.name)) {
                    File directory = project.getLocation().toFile();
                    HashSet<File> gitDirs = new HashSet<File>();
                    GitUtils.findGitDirsRecursive(directory.getParentFile(), gitDirs, false);
                    for (File dir : gitDirs) {
                        if (!repository.getDirectory().equals(dir)) continue;
                        this.project = project;
                        this.directory = directory;
                        break;
                    }
                }
                if (this.project != null) break;
                ++n2;
            }
        }
        return this.project;
    }

    @Override
    public boolean isLoaded() {
        return this.project != null;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.project = null;
        this.directory = null;
    }

    @Override
    public List<? extends IKieResourceHandler> getChildren() throws Exception {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof KieProjectHandler) {
            KieProjectHandler that = (KieProjectHandler)obj;
            if (this.directory != null ? !this.directory.equals(that.directory) : that.directory != null) {
                return false;
            }
            if (this.project != null ? !this.project.equals((Object)that.project) || this.project.isOpen() != that.project.isOpen() : that.project != null) {
                return false;
            }
        }
        return super.equals(obj);
    }

    @Override
    public File getDirectory() {
        return this.directory;
    }
}

