/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.common.business;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.drools.ClassObjectFilter;
import org.drools.WorkingMemory;
import org.drools.planner.core.Solver;
import org.drools.planner.core.event.SolverEventListener;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.constraint.ConstraintOccurrence;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.core.solver.DefaultSolver;
import org.drools.planner.core.solver.DefaultSolverScope;
import org.drools.planner.core.solver.PlanningFactChange;
import org.drools.planner.examples.common.business.ScoreDetail;
import org.drools.planner.examples.common.persistence.AbstractSolutionExporter;
import org.drools.planner.examples.common.persistence.AbstractSolutionImporter;
import org.drools.planner.examples.common.persistence.SolutionDao;
import org.drools.runtime.ObjectFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolutionBusiness {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private SolutionDao solutionDao;
    private AbstractSolutionImporter importer;
    private AbstractSolutionExporter exporter;
    private File importDataDir;
    private File unsolvedDataDir;
    private File solvedDataDir;
    private File exportDataDir;
    private volatile Solver solver;
    private DefaultSolverScope solverScope;

    public void setSolutionDao(SolutionDao solutionDao) {
        this.solutionDao = solutionDao;
    }

    public void setImporter(AbstractSolutionImporter importer) {
        this.importer = importer;
    }

    public void setExporter(AbstractSolutionExporter exporter) {
        this.exporter = exporter;
    }

    public File getDataDir() {
        return this.solutionDao.getDataDir();
    }

    public String getDirName() {
        return this.solutionDao.getDirName();
    }

    public boolean hasImporter() {
        return this.importer != null;
    }

    public boolean hasExporter() {
        return this.exporter != null;
    }

    public void updateDataDirs() {
        if (this.hasImporter()) {
            this.importDataDir = new File(this.getDataDir(), "input");
            if (!this.importDataDir.exists()) {
                throw new IllegalStateException("The directory importDataDir (" + this.importDataDir.getAbsolutePath() + ") does not exist. The working directory should be set to drools-planner-examples.");
            }
        }
        this.unsolvedDataDir = new File(this.getDataDir(), "unsolved");
        if (!this.unsolvedDataDir.exists()) {
            throw new IllegalStateException("The directory unsolvedDataDir (" + this.unsolvedDataDir.getAbsolutePath() + ") does not exist. The working directory should be set to drools-planner-examples.");
        }
        this.solvedDataDir = new File(this.getDataDir(), "solved");
        if (!this.solvedDataDir.exists() && !this.solvedDataDir.mkdir()) {
            throw new IllegalStateException("The directory solvedDataDir (" + this.solvedDataDir.getAbsolutePath() + ") does not exist and could not be created.");
        }
        if (this.hasExporter()) {
            this.exportDataDir = new File(this.getDataDir(), "output");
            if (!this.exportDataDir.exists() && !this.exportDataDir.mkdir()) {
                throw new IllegalStateException("The directory exportDataDir (" + this.exportDataDir.getAbsolutePath() + ") does not exist and could not be created.");
            }
        }
    }

    public File getImportDataDir() {
        return this.importDataDir;
    }

    public File getUnsolvedDataDir() {
        return this.unsolvedDataDir;
    }

    public File getSolvedDataDir() {
        return this.solvedDataDir;
    }

    public File getExportDataDir() {
        return this.exportDataDir;
    }

    public void setSolver(Solver solver) {
        this.solver = solver;
        this.solverScope = ((DefaultSolver)solver).getSolverScope();
    }

    public List<File> getUnsolvedFileList() {
        List<File> unsolvedFileList = Arrays.asList(this.unsolvedDataDir.listFiles(new SolverExampleFileFilter()));
        Collections.sort(unsolvedFileList);
        return unsolvedFileList;
    }

    public List<File> getSolvedFileList() {
        List<File> solvedFileList = Arrays.asList(this.solvedDataDir.listFiles(new SolverExampleFileFilter()));
        Collections.sort(solvedFileList);
        return solvedFileList;
    }

    public Solution getSolution() {
        return this.solverScope.getWorkingSolution();
    }

    public Score getScore() {
        return this.solverScope.calculateScoreFromWorkingMemory();
    }

    public void addSolverEventLister(SolverEventListener eventListener) {
        this.solver.addEventListener(eventListener);
    }

    public List<ScoreDetail> getScoreDetailList() {
        HashMap<String, ScoreDetail> scoreDetailMap = new HashMap<String, ScoreDetail>();
        WorkingMemory workingMemory = this.solverScope.getWorkingMemory();
        if (workingMemory == null) {
            return Collections.emptyList();
        }
        Iterator it = workingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(ConstraintOccurrence.class));
        while (it.hasNext()) {
            ConstraintOccurrence constraintOccurrence = (ConstraintOccurrence)it.next();
            ScoreDetail scoreDetail = (ScoreDetail)scoreDetailMap.get(constraintOccurrence.getRuleId());
            if (scoreDetail == null) {
                scoreDetail = new ScoreDetail(constraintOccurrence.getRuleId(), constraintOccurrence.getConstraintType());
                scoreDetailMap.put(constraintOccurrence.getRuleId(), scoreDetail);
            }
            scoreDetail.addConstraintOccurrence(constraintOccurrence);
        }
        ArrayList<ScoreDetail> scoreDetailList = new ArrayList<ScoreDetail>(scoreDetailMap.values());
        Collections.sort(scoreDetailList);
        return scoreDetailList;
    }

    public void importSolution(File file) {
        Solution solution = this.importer.readSolution(file);
        this.solver.setStartingSolution(solution);
    }

    public void openSolution(File file) {
        Solution solution = this.solutionDao.readSolution(file);
        this.solver.setStartingSolution(solution);
    }

    public void saveSolution(File file) {
        Solution solution = this.solverScope.getWorkingSolution();
        this.solutionDao.writeSolution(solution, file);
    }

    public void exportSolution(File file) {
        Solution solution = this.solverScope.getWorkingSolution();
        this.exporter.writeSolution(solution, file);
    }

    public void doMove(Move move) {
        if (!move.isMoveDoable(this.solverScope.getWorkingMemory())) {
            this.logger.info("Not doing user move ({}) because it is not doable.", (Object)move);
            return;
        }
        this.logger.info("Doing user move ({}).", (Object)move);
        move.doMove(this.solverScope.getWorkingMemory());
    }

    public void doPlanningFactChange(PlanningFactChange planningFactChange) {
        if (this.solver.isSolving()) {
            this.solver.addPlanningFactChange(planningFactChange);
        } else {
            planningFactChange.doChange(this.solverScope.getSolutionDirector());
        }
    }

    public void solve() {
        this.solver.solve();
    }

    public void terminateSolvingEarly() {
        this.solver.terminateEarly();
    }

    public class SolverExampleFileFilter
    implements FileFilter {
        public boolean accept(File file) {
            if (file.isDirectory() || file.isHidden()) {
                return false;
            }
            return file.getName().endsWith(".xml");
        }
    }
}

