/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.nqueens.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.drools.planner.api.domain.solution.PlanningEntityCollectionProperty;
import org.drools.planner.core.score.SimpleScore;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.domain.AbstractPersistable;
import org.drools.planner.examples.nqueens.domain.Queen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NQueens
extends AbstractPersistable
implements Solution<SimpleScore> {
    private List<Queen> queenList;
    private SimpleScore score;

    @PlanningEntityCollectionProperty
    public List<Queen> getQueenList() {
        return this.queenList;
    }

    public void setQueenList(List<Queen> queenList) {
        this.queenList = queenList;
    }

    @Override
    public SimpleScore getScore() {
        return this.score;
    }

    @Override
    public void setScore(SimpleScore score) {
        this.score = score;
    }

    public int getN() {
        return this.queenList.size();
    }

    public List<Integer> getColumnList() {
        int n = this.getN();
        ArrayList<Integer> yList = new ArrayList<Integer>(n);
        for (int i = 0; i < n; ++i) {
            yList.add(i);
        }
        return yList;
    }

    @Override
    public Collection<? extends Object> getProblemFacts() {
        return Collections.emptyList();
    }

    public NQueens cloneSolution() {
        NQueens clone = new NQueens();
        clone.id = this.id;
        ArrayList<Queen> clonedQueenList = new ArrayList<Queen>(this.queenList.size());
        for (Queen queen : this.queenList) {
            clonedQueenList.add(queen.clone());
        }
        clone.queenList = clonedQueenList;
        clone.score = this.score;
        return clone;
    }
}

