/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.nurserostering.solver.move.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.drools.planner.core.move.CompositeMove;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.move.factory.AbstractMoveFactory;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.nurserostering.domain.Assignment;
import org.drools.planner.examples.nurserostering.domain.Employee;
import org.drools.planner.examples.nurserostering.domain.NurseRoster;
import org.drools.planner.examples.nurserostering.solver.move.EmployeeChangeMove;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignmentSequenceSwitchLength2MoveFactory
extends AbstractMoveFactory {
    @Override
    public List<Move> createMoveList(Solution solution) {
        NurseRoster nurseRoster = (NurseRoster)solution;
        List<Employee> employeeList = nurseRoster.getEmployeeList();
        List<Assignment> assignmentList = nurseRoster.getAssignmentList();
        HashMap employeeToAssignmentSequenceListMap = new HashMap(employeeList.size());
        int assignmentSequenceCapacity = nurseRoster.getShiftDateList().size() + 0;
        for (Employee employee : employeeList) {
            employeeToAssignmentSequenceListMap.put(employee, new ArrayList(assignmentSequenceCapacity));
        }
        for (Assignment assignment : assignmentList) {
            Employee employee = assignment.getEmployee();
            List assignmentSequenceList = (List)employeeToAssignmentSequenceListMap.get(employee);
            if (assignmentSequenceList.isEmpty()) {
                AssignmentSequence assignmentSequence = new AssignmentSequence(assignment);
                assignmentSequenceList.add(assignmentSequence);
                continue;
            }
            AssignmentSequence lastAssignmentSequence = (AssignmentSequence)assignmentSequenceList.get(assignmentSequenceList.size() - 1);
            if (lastAssignmentSequence.belongsHere(assignment)) {
                lastAssignmentSequence.add(assignment);
                continue;
            }
            AssignmentSequence assignmentSequence = new AssignmentSequence(assignment);
            assignmentSequenceList.add(assignmentSequence);
        }
        ArrayList<Move> moveList = new ArrayList<Move>();
        ListIterator<Employee> leftEmployeeIt = employeeList.listIterator();
        while (leftEmployeeIt.hasNext()) {
            Employee leftEmployee = leftEmployeeIt.next();
            List leftAssignmentSequenceList = (List)employeeToAssignmentSequenceListMap.get(leftEmployee);
            ListIterator<Employee> rightEmployeeIt = employeeList.listIterator(leftEmployeeIt.nextIndex());
            while (rightEmployeeIt.hasNext()) {
                Employee rightEmployee = rightEmployeeIt.next();
                List rightAssignmentSequenceList = (List)employeeToAssignmentSequenceListMap.get(rightEmployee);
                int SWITCH_LENGTH = 2;
                for (AssignmentSequence leftAssignmentSequence : leftAssignmentSequenceList) {
                    List<Assignment> leftAssignmentList = leftAssignmentSequence.getAssignmentList();
                    for (int leftIndex = 0; leftIndex <= leftAssignmentList.size() - 2; ++leftIndex) {
                        for (AssignmentSequence rightAssignmentSequence : rightAssignmentSequenceList) {
                            List<Assignment> rightAssignmentList = rightAssignmentSequence.getAssignmentList();
                            for (int rightIndex = 0; rightIndex <= rightAssignmentList.size() - 2; ++rightIndex) {
                                ArrayList<Move> subMoveList = new ArrayList<Move>(4);
                                for (Assignment leftAssignment : leftAssignmentList.subList(leftIndex, leftIndex + 2)) {
                                    subMoveList.add(new EmployeeChangeMove(leftAssignment, rightEmployee));
                                }
                                for (Assignment rightAssignment : rightAssignmentList.subList(rightIndex, rightIndex + 2)) {
                                    subMoveList.add(new EmployeeChangeMove(rightAssignment, leftEmployee));
                                }
                                moveList.add(new CompositeMove(subMoveList));
                            }
                        }
                    }
                }
            }
        }
        return moveList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AssignmentSequence {
        private List<Assignment> assignmentList = new ArrayList<Assignment>();
        private int firstDayIndex;
        private int lastDayIndex;

        private AssignmentSequence(Assignment assignment) {
            this.assignmentList.add(assignment);
            this.lastDayIndex = this.firstDayIndex = assignment.getShiftDateDayIndex();
        }

        public List<Assignment> getAssignmentList() {
            return this.assignmentList;
        }

        public int getFirstDayIndex() {
            return this.firstDayIndex;
        }

        public int getLastDayIndex() {
            return this.lastDayIndex;
        }

        private void add(Assignment assignment) {
            this.assignmentList.add(assignment);
            int dayIndex = assignment.getShiftDateDayIndex();
            if (dayIndex < this.lastDayIndex) {
                throw new IllegalStateException("The assignmentList is expected to be sorted by shiftDate.");
            }
            this.lastDayIndex = dayIndex;
        }

        private boolean belongsHere(Assignment assignment) {
            return assignment.getShiftDateDayIndex() <= this.lastDayIndex + 1;
        }
    }
}

