/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.tsp.swingui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.tsp.domain.City;
import org.drools.planner.examples.tsp.domain.CityAssignment;
import org.drools.planner.examples.tsp.domain.TravelingSalesmanTour;
import org.drools.planner.examples.tsp.swingui.TspPanel;

public class TspWorldPanel
extends JPanel {
    private final TspPanel tspPanel;
    private BufferedImage canvas = null;

    public TspWorldPanel(TspPanel tspPanel) {
        this.tspPanel = tspPanel;
    }

    public void resetPanel(Solution solution) {
        TravelingSalesmanTour travelingSalesmanTour = (TravelingSalesmanTour)solution;
        LatitudeLongitudeTranslator translator = new LatitudeLongitudeTranslator();
        for (City city : travelingSalesmanTour.getCityList()) {
            translator.addCoordinates(city.getLatitude(), city.getLongitude());
        }
        Dimension size = this.getSize();
        double width = size.getWidth();
        double height = size.getHeight();
        translator.prepareFor(width, height);
        Graphics g = this.createCanvas(width, height);
        g.setColor(Color.RED);
        for (City city : travelingSalesmanTour.getCityList()) {
            int x = translator.translateLongitude(city.getLongitude());
            int y = translator.translateLatitude(city.getLatitude());
            g.fillRect(x - 1, y - 1, 3, 3);
        }
        g.setColor(Color.BLACK);
        for (CityAssignment cityAssignment : travelingSalesmanTour.getCityAssignmentList()) {
            City city1 = cityAssignment.getCity();
            int x1 = translator.translateLongitude(city1.getLongitude());
            int y1 = translator.translateLatitude(city1.getLatitude());
            City city2 = cityAssignment.getNextCityAssignment().getCity();
            int x2 = translator.translateLongitude(city2.getLongitude());
            int y2 = translator.translateLatitude(city2.getLatitude());
            g.drawLine(x1, y1, x2, y2);
        }
        this.repaint();
    }

    private Graphics createCanvas(double width, double height) {
        int canvasWidth = (int)Math.ceil(width) + 1;
        int canvasHeight = (int)Math.ceil(height) + 1;
        this.canvas = new BufferedImage(canvasWidth, canvasHeight, 1);
        Graphics g = this.canvas.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, canvasWidth, canvasHeight);
        return g;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.canvas != null) {
            g.drawImage(this.canvas, 0, 0, this);
        }
    }

    private class LatitudeLongitudeTranslator {
        private double minimumLatitude = Double.MAX_VALUE;
        private double maximumLatitude = -1.7976931348623157E308;
        private double minimumLongitude = Double.MAX_VALUE;
        private double maximumLongitude = -1.7976931348623157E308;
        private double latitudeLength = 0.0;
        private double longitudeLength = 0.0;
        private double width = 0.0;
        private double height = 0.0;

        private LatitudeLongitudeTranslator() {
        }

        public void addCoordinates(double latitude, double longitude) {
            if (latitude < this.minimumLatitude) {
                this.minimumLatitude = latitude;
            }
            if (latitude > this.maximumLatitude) {
                this.maximumLatitude = latitude;
            }
            if (longitude < this.minimumLongitude) {
                this.minimumLongitude = longitude;
            }
            if (longitude > this.maximumLongitude) {
                this.maximumLongitude = longitude;
            }
        }

        public void prepareFor(double width, double height) {
            this.width = width;
            this.height = height;
            this.latitudeLength = this.maximumLatitude - this.minimumLatitude;
            this.longitudeLength = this.maximumLongitude - this.minimumLongitude;
        }

        public int translateLongitude(double value) {
            return (int)Math.floor((value - this.minimumLongitude) * this.width / this.longitudeLength);
        }

        public int translateLatitude(double value) {
            return (int)Math.floor((this.maximumLatitude - value) * this.height / this.latitudeLength);
        }
    }
}

