/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.benchmark;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.drools.planner.benchmark.SolverBenchmark;
import org.drools.planner.benchmark.SolverBenchmarkResult;
import org.drools.planner.benchmark.TotalScoreSolverBenchmarkComparator;
import org.drools.planner.benchmark.statistic.SolverStatistic;
import org.drools.planner.benchmark.statistic.bestscore.BestScoreStatistic;
import org.drools.planner.benchmark.statistic.calculatecount.CalculateCountStatistic;
import org.drools.planner.benchmark.statistic.memoryuse.MemoryUseStatistic;
import org.drools.planner.config.termination.TerminationConfig;
import org.drools.planner.core.Solver;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.drools.planner.core.solution.Solution;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="solverBenchmarkSuite")
public class SolverBenchmarkSuite {
    public static final NumberFormat TIME_FORMAT = NumberFormat.getIntegerInstance(Locale.ENGLISH);
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private File benchmarkDirectory = null;
    private File solvedSolutionFilesDirectory = null;
    private File solverStatisticFilesDirectory = null;
    @XStreamImplicit(itemFieldName="solverStatisticType")
    private List<SolverStatisticType> solverStatisticTypeList = null;
    private Comparator<SolverBenchmark> solverBenchmarkComparator = null;
    private Long warmUpTimeMillisSpend = null;
    private Long warmUpSecondsSpend = null;
    private Long warmUpMinutesSpend = null;
    private Long warmUpHoursSpend = null;
    private SolverBenchmark inheritedSolverBenchmark = null;
    @XStreamImplicit(itemFieldName="solverBenchmark")
    private List<SolverBenchmark> solverBenchmarkList = null;

    public File getBenchmarkDirectory() {
        return this.benchmarkDirectory;
    }

    public void setBenchmarkDirectory(File benchmarkDirectory) {
        this.benchmarkDirectory = benchmarkDirectory;
    }

    public File getSolvedSolutionFilesDirectory() {
        return this.solvedSolutionFilesDirectory;
    }

    public void setSolvedSolutionFilesDirectory(File solvedSolutionFilesDirectory) {
        this.solvedSolutionFilesDirectory = solvedSolutionFilesDirectory;
    }

    public File getSolverStatisticFilesDirectory() {
        return this.solverStatisticFilesDirectory;
    }

    public void setSolverStatisticFilesDirectory(File solverStatisticFilesDirectory) {
        this.solverStatisticFilesDirectory = solverStatisticFilesDirectory;
    }

    public List<SolverStatisticType> getSolverStatisticTypeList() {
        return this.solverStatisticTypeList;
    }

    public void setSolverStatisticTypeList(List<SolverStatisticType> solverStatisticTypeList) {
        this.solverStatisticTypeList = solverStatisticTypeList;
    }

    public Comparator<SolverBenchmark> getSolverBenchmarkComparator() {
        return this.solverBenchmarkComparator;
    }

    public void setSolverBenchmarkComparator(Comparator<SolverBenchmark> solverBenchmarkComparator) {
        this.solverBenchmarkComparator = solverBenchmarkComparator;
    }

    public Long getWarmUpTimeMillisSpend() {
        return this.warmUpTimeMillisSpend;
    }

    public void setWarmUpTimeMillisSpend(Long warmUpTimeMillisSpend) {
        this.warmUpTimeMillisSpend = warmUpTimeMillisSpend;
    }

    public Long getWarmUpSecondsSpend() {
        return this.warmUpSecondsSpend;
    }

    public void setWarmUpSecondsSpend(Long warmUpSecondsSpend) {
        this.warmUpSecondsSpend = warmUpSecondsSpend;
    }

    public Long getWarmUpMinutesSpend() {
        return this.warmUpMinutesSpend;
    }

    public void setWarmUpMinutesSpend(Long warmUpMinutesSpend) {
        this.warmUpMinutesSpend = warmUpMinutesSpend;
    }

    public Long getWarmUpHoursSpend() {
        return this.warmUpHoursSpend;
    }

    public void setWarmUpHoursSpend(Long warmUpHoursSpend) {
        this.warmUpHoursSpend = warmUpHoursSpend;
    }

    public List<SolverBenchmark> getSolverBenchmarkList() {
        return this.solverBenchmarkList;
    }

    public void setSolverBenchmarkList(List<SolverBenchmark> solverBenchmarkList) {
        this.solverBenchmarkList = solverBenchmarkList;
    }

    public void benchmarkingStarted() {
        if (this.solverBenchmarkList == null || this.solverBenchmarkList.isEmpty()) {
            throw new IllegalArgumentException("Configure at least 1 <solverBenchmark> in the <solverBenchmarkSuite> configuration.");
        }
        HashSet<String> nameSet = new HashSet<String>(this.solverBenchmarkList.size());
        LinkedHashSet<SolverBenchmark> noNameBenchmarkSet = new LinkedHashSet<SolverBenchmark>(this.solverBenchmarkList.size());
        for (SolverBenchmark solverBenchmark : this.solverBenchmarkList) {
            if (solverBenchmark.getName() != null) {
                boolean unique = nameSet.add(solverBenchmark.getName());
                if (!unique) {
                    throw new IllegalStateException("The benchmark name (" + solverBenchmark.getName() + ") is used in more than 1 benchmark.");
                }
            } else {
                noNameBenchmarkSet.add(solverBenchmark);
            }
            if (this.inheritedSolverBenchmark != null) {
                solverBenchmark.inherit(this.inheritedSolverBenchmark);
            }
            solverBenchmark.validate();
            solverBenchmark.resetSolverBenchmarkResultList();
        }
        int generatedNameIndex = 0;
        for (SolverBenchmark solverBenchmark : noNameBenchmarkSet) {
            String generatedName = "Config_" + generatedNameIndex;
            while (nameSet.contains(generatedName)) {
                generatedName = "Config_" + ++generatedNameIndex;
            }
            solverBenchmark.setName(generatedName);
            ++generatedNameIndex;
        }
        if (this.benchmarkDirectory == null) {
            throw new IllegalArgumentException("The benchmarkDirectory (" + this.benchmarkDirectory + ") must not be null.");
        }
        this.benchmarkDirectory.mkdirs();
        if (this.solvedSolutionFilesDirectory == null) {
            this.solvedSolutionFilesDirectory = new File(this.benchmarkDirectory, "solved");
        }
        this.solvedSolutionFilesDirectory.mkdirs();
        if (this.solverStatisticFilesDirectory == null) {
            this.solverStatisticFilesDirectory = new File(this.benchmarkDirectory, "statistic");
        }
        this.solverStatisticFilesDirectory.mkdirs();
        if (this.solverBenchmarkComparator == null) {
            this.solverBenchmarkComparator = new TotalScoreSolverBenchmarkComparator();
        }
    }

    public void benchmark(XStream xStream) {
        this.benchmarkingStarted();
        LinkedHashMap<File, List<SolverStatistic>> unsolvedSolutionFileToStatisticMap = new LinkedHashMap<File, List<SolverStatistic>>();
        if (this.warmUpTimeMillisSpend != null || this.warmUpSecondsSpend != null || this.warmUpMinutesSpend != null || this.warmUpHoursSpend != null) {
            this.logger.info("================================================================================");
            this.logger.info("Warming up");
            this.logger.info("================================================================================");
            long warmUpTimeMillisSpendTotal = 0L;
            if (this.warmUpTimeMillisSpend != null) {
                warmUpTimeMillisSpendTotal += this.warmUpTimeMillisSpend.longValue();
            }
            if (this.warmUpSecondsSpend != null) {
                warmUpTimeMillisSpendTotal += this.warmUpSecondsSpend * 1000L;
            }
            if (this.warmUpMinutesSpend != null) {
                warmUpTimeMillisSpendTotal += this.warmUpMinutesSpend * 60000L;
            }
            if (this.warmUpHoursSpend != null) {
                warmUpTimeMillisSpendTotal += this.warmUpHoursSpend * 3600000L;
            }
            long startingTimeMillis = System.currentTimeMillis();
            long timeLeft = warmUpTimeMillisSpendTotal;
            Iterator<SolverBenchmark> solverBenchmarkIt = this.solverBenchmarkList.iterator();
            int overallResultIndex = 0;
            while (timeLeft > 0L) {
                if (!solverBenchmarkIt.hasNext()) {
                    solverBenchmarkIt = this.solverBenchmarkList.iterator();
                    ++overallResultIndex;
                }
                SolverBenchmark solverBenchmark = solverBenchmarkIt.next();
                List<SolverBenchmarkResult> solverBenchmarkResultList = solverBenchmark.getSolverBenchmarkResultList();
                int resultIndex = overallResultIndex % solverBenchmarkResultList.size();
                SolverBenchmarkResult result = solverBenchmarkResultList.get(resultIndex);
                TerminationConfig originalTerminationConfig = solverBenchmark.getSolverConfig().getTerminationConfig();
                TerminationConfig tmpTerminationConfig = originalTerminationConfig.clone();
                tmpTerminationConfig.shortenMaximumTimeMillisSpendTotal(timeLeft);
                solverBenchmark.getSolverConfig().setTerminationConfig(tmpTerminationConfig);
                Solver solver = solverBenchmark.getSolverConfig().buildSolver();
                File unsolvedSolutionFile = result.getUnsolvedSolutionFile();
                Solution unsolvedSolution = this.readUnsolvedSolution(xStream, unsolvedSolutionFile);
                solver.setStartingSolution(unsolvedSolution);
                solver.solve();
                solverBenchmark.getSolverConfig().setTerminationConfig(originalTerminationConfig);
                long timeSpend = System.currentTimeMillis() - startingTimeMillis;
                timeLeft = warmUpTimeMillisSpendTotal - timeSpend;
            }
            this.logger.info("================================================================================");
            this.logger.info("Finished warmUp");
            this.logger.info("================================================================================");
        }
        for (SolverBenchmark solverBenchmark : this.solverBenchmarkList) {
            for (SolverBenchmarkResult result : solverBenchmark.getSolverBenchmarkResultList()) {
                Solver solver = solverBenchmark.getSolverConfig().buildSolver();
                File unsolvedSolutionFile = result.getUnsolvedSolutionFile();
                Solution unsolvedSolution = this.readUnsolvedSolution(xStream, unsolvedSolutionFile);
                solver.setStartingSolution(unsolvedSolution);
                List<SolverStatistic> statisticList = this.getOrCreateStatisticList(unsolvedSolutionFileToStatisticMap, unsolvedSolutionFile);
                for (SolverStatistic statistic : statisticList) {
                    statistic.addListener(solver, solverBenchmark.getName());
                }
                solver.solve();
                result.setTimeMillisSpend(solver.getTimeMillisSpend());
                Solution solvedSolution = solver.getBestSolution();
                result.setScore((Score)solvedSolution.getScore());
                for (SolverStatistic statistic : statisticList) {
                    statistic.removeListener(solver, solverBenchmark.getName());
                }
                this.writeSolvedSolution(xStream, solverBenchmark, result, solvedSolution);
            }
        }
        this.benchmarkingEnded(xStream, unsolvedSolutionFileToStatisticMap);
    }

    private List<SolverStatistic> getOrCreateStatisticList(Map<File, List<SolverStatistic>> unsolvedSolutionFileToStatisticMap, File unsolvedSolutionFile) {
        if (this.solverStatisticTypeList == null) {
            return Collections.emptyList();
        }
        List<SolverStatistic> statisticList = unsolvedSolutionFileToStatisticMap.get(unsolvedSolutionFile);
        if (statisticList == null) {
            statisticList = new ArrayList<SolverStatistic>(this.solverStatisticTypeList.size());
            for (SolverStatisticType solverStatisticType : this.solverStatisticTypeList) {
                statisticList.add(solverStatisticType.create());
            }
            unsolvedSolutionFileToStatisticMap.put(unsolvedSolutionFile, statisticList);
        }
        return statisticList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Solution readUnsolvedSolution(XStream xStream, File unsolvedSolutionFile) {
        Solution unsolvedSolution;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(unsolvedSolutionFile), "utf-8");
            unsolvedSolution = (Solution)xStream.fromXML((Reader)reader);
        }
        catch (XStreamException e) {
            try {
                throw new IllegalArgumentException("Problem reading unsolvedSolutionFile: " + unsolvedSolutionFile, e);
                catch (IOException e2) {
                    throw new IllegalArgumentException("Problem reading unsolvedSolutionFile: " + unsolvedSolutionFile, e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return unsolvedSolution;
    }

    private void writeSolvedSolution(XStream xStream, SolverBenchmark solverBenchmark, SolverBenchmarkResult result, Solution solvedSolution) {
        if (this.solvedSolutionFilesDirectory == null) {
            return;
        }
        File solvedSolutionFile = null;
        String baseName = FilenameUtils.getBaseName((String)result.getUnsolvedSolutionFile().getName());
        String solverBenchmarkName = solverBenchmark.getName().replaceAll(" ", "_").replaceAll("[^\\w\\d_\\-]", "");
        String scoreString = result.getScore().toString().replaceAll("[\\/ ]", "_");
        String timeString = TIME_FORMAT.format(result.getTimeMillisSpend()) + "ms";
        solvedSolutionFile = new File(this.solvedSolutionFilesDirectory, baseName + "_" + solverBenchmarkName + "_score" + scoreString + "_time" + timeString + ".xml");
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(solvedSolutionFile), "utf-8");
            xStream.toXML((Object)solvedSolution, (Writer)writer);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Problem writing solvedSolutionFile: " + solvedSolutionFile, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    public void benchmarkingEnded(XStream xStream, Map<File, List<SolverStatistic>> unsolvedSolutionFileToStatisticMap) {
        this.determineRankings();
        StringBuilder htmlFragment = new StringBuilder(unsolvedSolutionFileToStatisticMap.size() * 160);
        htmlFragment.append("  <h1>Summary</h1>\n");
        htmlFragment.append("  <h2>Summary chart</h2>\n");
        htmlFragment.append(this.writeBestScoreSummaryChart());
        htmlFragment.append("  <h2>Summary table</h2>\n");
        htmlFragment.append(this.writeBestScoreSummaryTable());
        htmlFragment.append("  <h1>Statistics</h1>\n");
        for (Map.Entry<File, List<SolverStatistic>> entry : unsolvedSolutionFileToStatisticMap.entrySet()) {
            File unsolvedSolutionFile = entry.getKey();
            List<SolverStatistic> statisticList = entry.getValue();
            String baseName = FilenameUtils.getBaseName((String)unsolvedSolutionFile.getName());
            htmlFragment.append("  <h2>").append(baseName).append("</h2>\n");
            Iterator<SolverStatisticType> typeIt = this.solverStatisticTypeList.iterator();
            for (SolverStatistic statistic : statisticList) {
                htmlFragment.append("  <h3>").append(typeIt.next().toString()).append("</h3>\n");
                htmlFragment.append(statistic.writeStatistic(this.solverStatisticFilesDirectory, baseName));
            }
        }
        this.writeHtmlOverview(htmlFragment);
        this.writeBenchmarkResult(xStream);
    }

    private void determineRankings() {
        ArrayList<SolverBenchmark> sortedSolverBenchmarkList = new ArrayList<SolverBenchmark>(this.solverBenchmarkList);
        Collections.sort(sortedSolverBenchmarkList, this.solverBenchmarkComparator);
        Collections.reverse(sortedSolverBenchmarkList);
        for (SolverBenchmark solverBenchmark : this.solverBenchmarkList) {
            solverBenchmark.setRanking(sortedSolverBenchmarkList.indexOf(solverBenchmark));
        }
    }

    private CharSequence writeBestScoreSummaryChart() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (SolverBenchmark solverBenchmark : this.solverBenchmarkList) {
            ScoreDefinition scoreDefinition = solverBenchmark.getSolverConfig().getScoreDefinitionConfig().buildScoreDefinition();
            for (SolverBenchmarkResult result : solverBenchmark.getSolverBenchmarkResultList()) {
                Score score = result.getScore();
                Double scoreGraphValue = scoreDefinition.translateScoreToGraphValue(score);
                String solverLabel = solverBenchmark.getName();
                if (solverBenchmark.getRanking() == 0) {
                    solverLabel = solverLabel + " (winner)";
                }
                dataset.addValue((Number)scoreGraphValue, (Comparable)((Object)solverLabel), (Comparable)((Object)result.getUnsolvedSolutionFile().getName()));
            }
        }
        JFreeChart chart = ChartFactory.createBarChart((String)"Best score summary (higher score is better)", (String)"Data", (String)"Score", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        CategoryItemRenderer renderer = ((CategoryPlot)chart.getPlot()).getRenderer();
        StandardCategoryItemLabelGenerator generator = new StandardCategoryItemLabelGenerator();
        renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)generator);
        renderer.setBaseItemLabelsVisible(true);
        BufferedImage chartImage = chart.createBufferedImage(1024, 768);
        File chartSummaryFile = new File(this.solverStatisticFilesDirectory, "summary.png");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(chartSummaryFile);
            ImageIO.write((RenderedImage)chartImage, "png", out);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Problem writing graphStatisticFile: " + chartSummaryFile, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        return "  <img src=\"" + chartSummaryFile.getName() + "\"/>\n";
    }

    private CharSequence writeBestScoreSummaryTable() {
        StringBuilder htmlFragment = new StringBuilder(this.solverBenchmarkList.size() * 160);
        htmlFragment.append("  <table border=\"1\">\n");
        htmlFragment.append("    <tr><th/>");
        if (this.inheritedSolverBenchmark != null && this.inheritedSolverBenchmark.getUnsolvedSolutionFileList() != null) {
            for (File unsolvedSolutionFile : this.inheritedSolverBenchmark.getUnsolvedSolutionFileList()) {
                htmlFragment.append("<th>").append(unsolvedSolutionFile.getName()).append("</th>");
            }
        }
        htmlFragment.append("<th>Average</th><th>Ranking</th></tr>\n");
        boolean oddLine = true;
        for (SolverBenchmark solverBenchmark : this.solverBenchmarkList) {
            String backgroundColor = solverBenchmark.getRanking() == 0 ? "Yellow" : (oddLine ? "White" : "Gray");
            htmlFragment.append("    <tr style=\"background-color: ").append(backgroundColor).append("\"><th>").append(solverBenchmark.getName()).append("</th>");
            for (SolverBenchmarkResult result : solverBenchmark.getSolverBenchmarkResultList()) {
                Score score = result.getScore();
                htmlFragment.append("<td>").append(score.toString()).append("</td>");
            }
            htmlFragment.append("<td>").append(solverBenchmark.getAverageScore().toString()).append("</td><td>").append(solverBenchmark.getRanking()).append("</td>");
            htmlFragment.append("</tr>\n");
            oddLine = !oddLine;
        }
        htmlFragment.append("  </table>\n");
        return htmlFragment.toString();
    }

    private void writeHtmlOverview(CharSequence htmlFragment) {
        File htmlOverviewFile = new File(this.solverStatisticFilesDirectory, "index.html");
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(htmlOverviewFile), "utf-8");
            ((Writer)writer).append("<html>\n");
            ((Writer)writer).append("<head>\n");
            ((Writer)writer).append("  <title>Statistic</title>\n");
            ((Writer)writer).append("</head>\n");
            ((Writer)writer).append("<body>\n");
            ((Writer)writer).append(htmlFragment);
            ((Writer)writer).append("</body>\n");
            ((Writer)writer).append("</html>\n");
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Problem writing htmlOverviewFile: " + htmlOverviewFile, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeBenchmarkResult(XStream xStream) {
        File benchmarkResultFile = new File(this.benchmarkDirectory, "benchmarkResult.xml");
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(benchmarkResultFile), "utf-8");
            xStream.toXML((Object)this, (Writer)writer);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new IllegalStateException("This JVM does not support utf-8 encoding.", e);
                catch (FileNotFoundException e2) {
                    throw new IllegalArgumentException("Could not create benchmarkResultFile (" + benchmarkResultFile + ").", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SolverStatisticType {
        BEST_SOLUTION_CHANGED,
        CALCULATE_COUNT_PER_SECOND,
        MEMORY_USE;


        public SolverStatistic create() {
            switch (this) {
                case BEST_SOLUTION_CHANGED: {
                    return new BestScoreStatistic();
                }
                case CALCULATE_COUNT_PER_SECOND: {
                    return new CalculateCountStatistic();
                }
                case MEMORY_USE: {
                    return new MemoryUseStatistic();
                }
            }
            throw new IllegalStateException("The solverStatisticType (" + (Object)((Object)this) + ") is not implemented");
        }
    }
}

