/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.benchmark;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.IOUtils;
import org.drools.planner.benchmark.SolverBenchmarkSuite;
import org.drools.planner.config.XmlSolverConfigurer;

public class XmlSolverBenchmarker {
    private XStream xStream = XmlSolverConfigurer.buildXstream();
    private SolverBenchmarkSuite suite = null;

    public XmlSolverBenchmarker() {
        this.xStream.processAnnotations(SolverBenchmarkSuite.class);
    }

    public void addXstreamAnnotations(Class ... xstreamAnnotations) {
        this.xStream.processAnnotations(xstreamAnnotations);
    }

    public XmlSolverBenchmarker configure(String resource) {
        InputStream in = this.getClass().getResourceAsStream(resource);
        if (in == null) {
            throw new IllegalArgumentException("Resource not found: " + resource);
        }
        return this.configure(in);
    }

    public XmlSolverBenchmarker configure(InputStream in) {
        XmlSolverBenchmarker xmlSolverBenchmarker;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(in, "utf-8");
            xmlSolverBenchmarker = this.configure(reader);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new IllegalStateException("This vm does not support utf-8 encoding.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return xmlSolverBenchmarker;
    }

    public XmlSolverBenchmarker configure(Reader reader) {
        this.suite = (SolverBenchmarkSuite)this.xStream.fromXML(reader);
        return this;
    }

    public void benchmark() {
        if (this.suite == null) {
            throw new IllegalStateException("No configuration found, call SolverBenchmarker.configure(...) first.");
        }
        this.suite.benchmark(this.xStream);
    }
}

