/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.benchmark.statistic.calculatecount;

import java.util.ArrayList;
import java.util.List;
import org.drools.planner.benchmark.statistic.calculatecount.CalculateCountStatisticPoint;
import org.drools.planner.core.phase.event.SolverPhaseLifecycleListenerAdapter;
import org.drools.planner.core.phase.step.AbstractStepScope;
import org.drools.planner.core.solver.DefaultSolverScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalculateCountStatisticListener
extends SolverPhaseLifecycleListenerAdapter {
    private long timeMillisThresholdInterval;
    private long nextTimeMillisThreshold;
    private long lastTimeMillisSpend = 0L;
    private long lastCalculateCount = 0L;
    private List<CalculateCountStatisticPoint> statisticPointList = new ArrayList<CalculateCountStatisticPoint>();

    public CalculateCountStatisticListener() {
        this(1000L);
    }

    public CalculateCountStatisticListener(long timeMillisThresholdInterval) {
        if (timeMillisThresholdInterval <= 0L) {
            throw new IllegalArgumentException("The timeMillisThresholdInterval (" + timeMillisThresholdInterval + ") must be bigger than 0.");
        }
        this.timeMillisThresholdInterval = timeMillisThresholdInterval;
        this.nextTimeMillisThreshold = timeMillisThresholdInterval;
    }

    public List<CalculateCountStatisticPoint> getStatisticPointList() {
        return this.statisticPointList;
    }

    @Override
    public void stepTaken(AbstractStepScope stepScope) {
        long timeMillisSpend = stepScope.getSolverPhaseScope().calculateSolverTimeMillisSpend();
        if (timeMillisSpend >= this.nextTimeMillisThreshold) {
            long timeMillisSpendInterval = timeMillisSpend - this.lastTimeMillisSpend;
            DefaultSolverScope solverScope = stepScope.getSolverPhaseScope().getSolverScope();
            long calculateCount = solverScope.getCalculateCount();
            long calculateCountInterval = calculateCount - this.lastCalculateCount;
            long averageCalculateCountPerSecond = calculateCountInterval * 1000L / timeMillisSpendInterval;
            this.statisticPointList.add(new CalculateCountStatisticPoint(timeMillisSpend, averageCalculateCountPerSecond));
            this.lastCalculateCount = calculateCount;
            this.lastTimeMillisSpend = timeMillisSpend;
            this.nextTimeMillisThreshold += this.timeMillisThresholdInterval;
            if (this.nextTimeMillisThreshold < timeMillisSpend) {
                this.nextTimeMillisThreshold = timeMillisSpend;
            }
        }
    }
}

