/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.benchmark.statistic.memoryuse;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.drools.planner.benchmark.statistic.AbstractSolverStatistic;
import org.drools.planner.benchmark.statistic.MillisecondsSpendNumberFormat;
import org.drools.planner.benchmark.statistic.memoryuse.MemoryUseMeasurement;
import org.drools.planner.benchmark.statistic.memoryuse.MemoryUseStatisticListener;
import org.drools.planner.benchmark.statistic.memoryuse.MemoryUseStatisticPoint;
import org.drools.planner.core.Solver;
import org.drools.planner.core.solver.DefaultSolver;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYAreaRenderer2;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryUseStatistic
extends AbstractSolverStatistic {
    private List<String> configNameList = new ArrayList<String>();
    private Map<String, MemoryUseStatisticListener> statisticListenerMap = new LinkedHashMap<String, MemoryUseStatisticListener>();

    @Override
    public void addListener(Solver solver, String configName) {
        if (this.configNameList.contains(configName)) {
            throw new IllegalArgumentException("Cannot add a listener with the same configName (" + configName + ") twice.");
        }
        this.configNameList.add(configName);
        MemoryUseStatisticListener statisticListener = new MemoryUseStatisticListener();
        ((DefaultSolver)solver).addSolverPhaseLifecycleListener(statisticListener);
        this.statisticListenerMap.put(configName, statisticListener);
    }

    @Override
    public void removeListener(Solver solver, String configName) {
        MemoryUseStatisticListener statisticListener = this.statisticListenerMap.get(configName);
        ((DefaultSolver)solver).removeSolverPhaseLifecycleListener(statisticListener);
    }

    @Override
    public CharSequence writeStatistic(File solverStatisticFilesDirectory, String baseName) {
        StringBuilder htmlFragment = new StringBuilder();
        htmlFragment.append(this.writeCsvStatistic(solverStatisticFilesDirectory, baseName));
        htmlFragment.append(this.writeGraphStatistic(solverStatisticFilesDirectory, baseName));
        return htmlFragment;
    }

    private List<MemoryUseScvLine> extractCsvLineList() {
        HashMap<Long, MemoryUseScvLine> timeToBestScoresLineMap = new HashMap<Long, MemoryUseScvLine>();
        for (Map.Entry<String, MemoryUseStatisticListener> listenerEntry : this.statisticListenerMap.entrySet()) {
            String configName = listenerEntry.getKey();
            List<MemoryUseStatisticPoint> statisticPointList = listenerEntry.getValue().getStatisticPointList();
            for (MemoryUseStatisticPoint statisticPoint : statisticPointList) {
                long timeMillisSpend = statisticPoint.getTimeMillisSpend();
                MemoryUseScvLine line = (MemoryUseScvLine)timeToBestScoresLineMap.get(timeMillisSpend);
                if (line == null) {
                    line = new MemoryUseScvLine(timeMillisSpend);
                    timeToBestScoresLineMap.put(timeMillisSpend, line);
                }
                line.getConfigNameToMemoryUseMeasurementMap().put(configName, statisticPoint.getMemoryUseMeasurement());
            }
        }
        ArrayList<MemoryUseScvLine> csvLineList = new ArrayList<MemoryUseScvLine>(timeToBestScoresLineMap.values());
        Collections.sort(csvLineList);
        return csvLineList;
    }

    private CharSequence writeCsvStatistic(File solverStatisticFilesDirectory, String baseName) {
        List<MemoryUseScvLine> csvLineList = this.extractCsvLineList();
        File csvStatisticFile = new File(solverStatisticFilesDirectory, baseName + "MemoryUseStatistic.csv");
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(csvStatisticFile), "utf-8");
            ((Writer)writer).append("\"TimeMillisSpend\"");
            for (String configName : this.configNameList) {
                ((Writer)writer).append(",\"").append(configName.replaceAll("\\\"", "\\\"")).append(" used\"");
                ((Writer)writer).append(",\"").append(configName.replaceAll("\\\"", "\\\"")).append(" max\"");
            }
            ((Writer)writer).append("\n");
            for (MemoryUseScvLine line : csvLineList) {
                writer.write(Long.toString(line.getTimeMillisSpend()));
                for (String configName : this.configNameList) {
                    ((Writer)writer).append(",");
                    MemoryUseMeasurement memoryUseMeasurement = line.getConfigNameToMemoryUseMeasurementMap().get(configName);
                    if (memoryUseMeasurement == null) continue;
                    ((Writer)writer).append(Long.toString(memoryUseMeasurement.getUsedMemory()));
                    ((Writer)writer).append(",");
                    ((Writer)writer).append(Long.toString(memoryUseMeasurement.getMaxMemory()));
                }
                ((Writer)writer).append("\n");
            }
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Problem writing csvStatisticFile: " + csvStatisticFile, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
        return "  <p><a href=\"" + csvStatisticFile.getName() + "\">CVS file</a></p>\n";
    }

    private CharSequence writeGraphStatistic(File solverStatisticFilesDirectory, String baseName) {
        XYSeriesCollection seriesCollection = new XYSeriesCollection();
        for (Map.Entry<String, MemoryUseStatisticListener> listenerEntry : this.statisticListenerMap.entrySet()) {
            String configName = listenerEntry.getKey();
            XYSeries usedSeries = new XYSeries((Comparable)((Object)(configName + " used")));
            XYSeries maxSeries = new XYSeries((Comparable)((Object)(configName + " max")));
            List<MemoryUseStatisticPoint> statisticPointList = listenerEntry.getValue().getStatisticPointList();
            for (MemoryUseStatisticPoint statisticPoint : statisticPointList) {
                long timeMillisSpend = statisticPoint.getTimeMillisSpend();
                MemoryUseMeasurement memoryUseMeasurement = statisticPoint.getMemoryUseMeasurement();
                usedSeries.add((double)timeMillisSpend, (double)memoryUseMeasurement.getUsedMemory());
                maxSeries.add((double)timeMillisSpend, (double)memoryUseMeasurement.getMaxMemory());
            }
            seriesCollection.addSeries(usedSeries);
            seriesCollection.addSeries(maxSeries);
        }
        NumberAxis xAxis = new NumberAxis("Time millis spend");
        xAxis.setNumberFormatOverride((NumberFormat)new MillisecondsSpendNumberFormat());
        NumberAxis yAxis = new NumberAxis("Memory");
        yAxis.setAutoRangeIncludesZero(false);
        XYAreaRenderer2 renderer = new XYAreaRenderer2();
        XYPlot plot = new XYPlot((XYDataset)seriesCollection, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
        plot.setOrientation(PlotOrientation.VERTICAL);
        JFreeChart chart = new JFreeChart(baseName + " memory use statistic", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        BufferedImage chartImage = chart.createBufferedImage(1024, 768);
        File graphStatisticFile = new File(solverStatisticFilesDirectory, baseName + "MemoryUseStatistic.png");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(graphStatisticFile);
            ImageIO.write((RenderedImage)chartImage, "png", out);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Problem writing graphStatisticFile: " + graphStatisticFile, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        return "  <img src=\"" + graphStatisticFile.getName() + "\"/>\n";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MemoryUseScvLine
    implements Comparable<MemoryUseScvLine> {
        private long timeMillisSpend;
        private Map<String, MemoryUseMeasurement> configNameToMemoryUseMeasurementMap;

        public MemoryUseScvLine(long timeMillisSpend) {
            this.timeMillisSpend = timeMillisSpend;
            this.configNameToMemoryUseMeasurementMap = new HashMap<String, MemoryUseMeasurement>();
        }

        public long getTimeMillisSpend() {
            return this.timeMillisSpend;
        }

        public Map<String, MemoryUseMeasurement> getConfigNameToMemoryUseMeasurementMap() {
            return this.configNameToMemoryUseMeasurementMap;
        }

        @Override
        public int compareTo(MemoryUseScvLine other) {
            return this.timeMillisSpend < other.timeMillisSpend ? -1 : (this.timeMillisSpend > other.timeMillisSpend ? 1 : 0);
        }
    }
}

