/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.config.solver;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.planner.config.EnvironmentMode;
import org.drools.planner.config.phase.SolverPhaseConfig;
import org.drools.planner.config.score.definition.ScoreDefinitionConfig;
import org.drools.planner.config.termination.TerminationConfig;
import org.drools.planner.core.Solver;
import org.drools.planner.core.bestsolution.BestSolutionRecaller;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.phase.AbstractSolverPhase;
import org.drools.planner.core.phase.SolverPhase;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.core.solution.director.DefaultSolutionDirector;
import org.drools.planner.core.solver.BasicPlumbingTermination;
import org.drools.planner.core.solver.DefaultSolver;
import org.drools.planner.core.termination.Termination;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="solver")
public class SolverConfig {
    protected static final long DEFAULT_RANDOM_SEED = 0L;
    protected EnvironmentMode environmentMode = null;
    protected Long randomSeed = null;
    protected Class<Solution> solutionClass = null;
    @XStreamImplicit(itemFieldName="planningEntityClass")
    protected Set<Class<?>> planningEntityClassSet = null;
    @XStreamOmitField
    protected RuleBase ruleBase = null;
    @XStreamImplicit(itemFieldName="scoreDrl")
    protected List<String> scoreDrlList = null;
    @XStreamAlias(value="scoreDefinition")
    protected ScoreDefinitionConfig scoreDefinitionConfig = new ScoreDefinitionConfig();
    @XStreamAlias(value="termination")
    private TerminationConfig terminationConfig = new TerminationConfig();
    @XStreamImplicit
    protected List<SolverPhaseConfig> solverPhaseConfigList = null;

    public EnvironmentMode getEnvironmentMode() {
        return this.environmentMode;
    }

    public void setEnvironmentMode(EnvironmentMode environmentMode) {
        this.environmentMode = environmentMode;
    }

    public Long getRandomSeed() {
        return this.randomSeed;
    }

    public void setRandomSeed(Long randomSeed) {
        this.randomSeed = randomSeed;
    }

    public Class<Solution> getSolutionClass() {
        return this.solutionClass;
    }

    public void setSolutionClass(Class<Solution> solutionClass) {
        this.solutionClass = solutionClass;
    }

    public Set<Class<?>> getPlanningEntityClassSet() {
        return this.planningEntityClassSet;
    }

    public void setPlanningEntityClassSet(Set<Class<?>> planningEntityClassSet) {
        this.planningEntityClassSet = planningEntityClassSet;
    }

    public RuleBase getRuleBase() {
        return this.ruleBase;
    }

    public void setRuleBase(RuleBase ruleBase) {
        this.ruleBase = ruleBase;
    }

    public List<String> getScoreDrlList() {
        return this.scoreDrlList;
    }

    public void setScoreDrlList(List<String> scoreDrlList) {
        this.scoreDrlList = scoreDrlList;
    }

    public ScoreDefinitionConfig getScoreDefinitionConfig() {
        return this.scoreDefinitionConfig;
    }

    public void setScoreDefinitionConfig(ScoreDefinitionConfig scoreDefinitionConfig) {
        this.scoreDefinitionConfig = scoreDefinitionConfig;
    }

    public TerminationConfig getTerminationConfig() {
        return this.terminationConfig;
    }

    public void setTerminationConfig(TerminationConfig terminationConfig) {
        this.terminationConfig = terminationConfig;
    }

    public List<SolverPhaseConfig> getSolverPhaseConfigList() {
        return this.solverPhaseConfigList;
    }

    public void setSolverPhaseConfigList(List<SolverPhaseConfig> solverPhaseConfigList) {
        this.solverPhaseConfigList = solverPhaseConfigList;
    }

    public Solver buildSolver() {
        DefaultSolver solver = new DefaultSolver();
        BasicPlumbingTermination basicPlumbingTermination = new BasicPlumbingTermination();
        solver.setBasicPlumbingTermination(basicPlumbingTermination);
        if (this.environmentMode != EnvironmentMode.PRODUCTION) {
            if (this.randomSeed != null) {
                solver.setRandomSeed(this.randomSeed);
            } else {
                solver.setRandomSeed(0L);
            }
        }
        SolutionDescriptor solutionDescriptor = this.buildSolutionDescriptor();
        DefaultSolutionDirector solutionDirector = new DefaultSolutionDirector();
        solutionDirector.setSolutionDescriptor(solutionDescriptor);
        solutionDirector.setRuleBase(this.buildRuleBase());
        ScoreDefinition scoreDefinition = this.scoreDefinitionConfig.buildScoreDefinition();
        solutionDirector.setScoreDefinition(scoreDefinition);
        solver.setSolutionDirector(solutionDirector);
        Termination termination = this.terminationConfig.buildTermination(scoreDefinition, basicPlumbingTermination);
        solver.setTermination(termination);
        BestSolutionRecaller bestSolutionRecaller = new BestSolutionRecaller();
        solver.setBestSolutionRecaller(bestSolutionRecaller);
        if (this.solverPhaseConfigList == null || this.solverPhaseConfigList.isEmpty()) {
            throw new IllegalArgumentException("Configure at least 1 phase (for example <localSearch>) in the solver configuration.");
        }
        ArrayList<SolverPhase> solverPhaseList = new ArrayList<SolverPhase>(this.solverPhaseConfigList.size());
        for (SolverPhaseConfig solverPhaseConfig : this.solverPhaseConfigList) {
            SolverPhase solverPhase = solverPhaseConfig.buildSolverPhase(this.environmentMode, solutionDescriptor, scoreDefinition, termination);
            ((AbstractSolverPhase)solverPhase).setBestSolutionRecaller(bestSolutionRecaller);
            solverPhaseList.add(solverPhase);
        }
        solver.setSolverPhaseList(solverPhaseList);
        return solver;
    }

    private SolutionDescriptor buildSolutionDescriptor() {
        if (this.solutionClass == null) {
            throw new IllegalArgumentException("Configure a <solutionClass> in the solver configuration.");
        }
        SolutionDescriptor solutionDescriptor = new SolutionDescriptor(this.solutionClass);
        if (this.planningEntityClassSet == null || this.planningEntityClassSet.isEmpty()) {
            throw new IllegalArgumentException("Configure at least 1 <planningEntityClass> in the solver configuration.");
        }
        for (Class<?> planningEntityClass : this.planningEntityClassSet) {
            PlanningEntityDescriptor planningEntityDescriptor = new PlanningEntityDescriptor(solutionDescriptor, planningEntityClass);
            solutionDescriptor.addPlanningEntityDescriptor(planningEntityDescriptor);
        }
        return solutionDescriptor;
    }

    private RuleBase buildRuleBase() {
        if (this.ruleBase != null) {
            if (this.scoreDrlList != null && !this.scoreDrlList.isEmpty()) {
                throw new IllegalArgumentException("If ruleBase is not null, the scoreDrlList (" + this.scoreDrlList + ") must be empty.");
            }
            return this.ruleBase;
        }
        PackageBuilder packageBuilder = new PackageBuilder();
        for (String scoreDrl : this.scoreDrlList) {
            InputStream scoreDrlIn = this.getClass().getResourceAsStream(scoreDrl);
            if (scoreDrlIn == null) {
                throw new IllegalArgumentException("scoreDrl (" + scoreDrl + ") does not exist as a classpath resource.");
            }
            try {
                packageBuilder.addPackageFromDrl((Reader)new InputStreamReader(scoreDrlIn, "utf-8"));
            }
            catch (DroolsParserException e) {
                throw new IllegalArgumentException("scoreDrl (" + scoreDrl + ") could not be loaded.", e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("scoreDrl (" + scoreDrl + ") could not be loaded.", e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)scoreDrlIn);
            }
        }
        RuleBaseConfiguration ruleBaseConfiguration = new RuleBaseConfiguration();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)ruleBaseConfiguration);
        if (packageBuilder.hasErrors()) {
            throw new IllegalStateException("There are errors in the scoreDrl's:" + packageBuilder.getErrors().toString());
        }
        ruleBase.addPackage(packageBuilder.getPackage());
        return ruleBase;
    }

    public void inherit(SolverConfig inheritedConfig) {
        if (this.environmentMode == null) {
            this.environmentMode = inheritedConfig.getEnvironmentMode();
        }
        if (this.randomSeed == null) {
            this.randomSeed = inheritedConfig.getRandomSeed();
        }
        if (this.solutionClass == null) {
            this.solutionClass = inheritedConfig.getSolutionClass();
        }
        if (this.planningEntityClassSet == null) {
            this.planningEntityClassSet = inheritedConfig.getPlanningEntityClassSet();
        } else if (inheritedConfig.getPlanningEntityClassSet() != null) {
            this.planningEntityClassSet.addAll(inheritedConfig.getPlanningEntityClassSet());
        }
        if (this.ruleBase == null) {
            this.ruleBase = inheritedConfig.getRuleBase();
        }
        if (this.scoreDrlList == null) {
            this.scoreDrlList = inheritedConfig.getScoreDrlList();
        } else {
            List<String> inheritedScoreDrlList = inheritedConfig.getScoreDrlList();
            if (inheritedScoreDrlList != null) {
                for (String inheritedScoreDrl : inheritedScoreDrlList) {
                    if (this.scoreDrlList.contains(inheritedScoreDrl)) continue;
                    this.scoreDrlList.add(inheritedScoreDrl);
                }
            }
        }
        if (this.scoreDefinitionConfig == null) {
            this.scoreDefinitionConfig = inheritedConfig.getScoreDefinitionConfig();
        } else if (inheritedConfig.getScoreDefinitionConfig() != null) {
            this.scoreDefinitionConfig.inherit(inheritedConfig.getScoreDefinitionConfig());
        }
        if (this.terminationConfig == null) {
            this.terminationConfig = inheritedConfig.getTerminationConfig();
        } else if (inheritedConfig.getTerminationConfig() != null) {
            this.terminationConfig.inherit(inheritedConfig.getTerminationConfig());
        }
        if (this.solverPhaseConfigList == null) {
            this.solverPhaseConfigList = inheritedConfig.getSolverPhaseConfigList();
        } else if (inheritedConfig.getSolverPhaseConfigList() != null) {
            ArrayList<SolverPhaseConfig> mergedList = new ArrayList<SolverPhaseConfig>(inheritedConfig.getSolverPhaseConfigList());
            mergedList.addAll(this.solverPhaseConfigList);
            this.solverPhaseConfigList = mergedList;
        }
    }
}

