/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.bruteforce;

import org.drools.planner.core.bruteforce.BruteForceEntityWalker;
import org.drools.planner.core.bruteforce.BruteForceSolverPhase;
import org.drools.planner.core.bruteforce.BruteForceSolverPhaseScope;
import org.drools.planner.core.bruteforce.BruteForceStepScope;
import org.drools.planner.core.bruteforce.event.BruteForceSolverPhaseLifecycleListener;
import org.drools.planner.core.phase.AbstractSolverPhase;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.solver.DefaultSolverScope;

public class DefaultBruteForceSolverPhase
extends AbstractSolverPhase
implements BruteForceSolverPhase,
BruteForceSolverPhaseLifecycleListener {
    protected BruteForceEntityWalker bruteForceEntityWalker;

    public void setBruteForceEntityWalker(BruteForceEntityWalker bruteForceEntityWalker) {
        this.bruteForceEntityWalker = bruteForceEntityWalker;
    }

    public void solve(DefaultSolverScope solverScope) {
        BruteForceSolverPhaseScope bruteForceSolverPhaseScope = new BruteForceSolverPhaseScope(solverScope);
        this.phaseStarted(bruteForceSolverPhaseScope);
        BruteForceStepScope bruteForceStepScope = this.createNextStepScope(bruteForceSolverPhaseScope, null);
        while (!this.termination.isPhaseTerminated(bruteForceSolverPhaseScope) && this.bruteForceEntityWalker.hasWalk()) {
            this.bruteForceEntityWalker.walk();
            Score score = bruteForceSolverPhaseScope.calculateScoreFromWorkingMemory();
            bruteForceStepScope.setScore(score);
            this.stepTaken(bruteForceStepScope);
            bruteForceStepScope = this.createNextStepScope(bruteForceSolverPhaseScope, bruteForceStepScope);
        }
        this.phaseEnded(bruteForceSolverPhaseScope);
    }

    private BruteForceStepScope createNextStepScope(BruteForceSolverPhaseScope bruteForceSolverPhaseScope, BruteForceStepScope completedBruteForceStepScope) {
        if (completedBruteForceStepScope == null) {
            completedBruteForceStepScope = new BruteForceStepScope(bruteForceSolverPhaseScope);
            completedBruteForceStepScope.setScore(bruteForceSolverPhaseScope.getStartingScore());
            completedBruteForceStepScope.setStepIndex(-1);
        }
        bruteForceSolverPhaseScope.setLastCompletedBruteForceStepScope(completedBruteForceStepScope);
        BruteForceStepScope bruteForceStepScope = new BruteForceStepScope(bruteForceSolverPhaseScope);
        bruteForceStepScope.setStepIndex(completedBruteForceStepScope.getStepIndex() + 1);
        bruteForceStepScope.setSolutionInitialized(true);
        return bruteForceStepScope;
    }

    public void phaseStarted(BruteForceSolverPhaseScope bruteForceSolverPhaseScope) {
        super.phaseStarted(bruteForceSolverPhaseScope);
        this.bruteForceEntityWalker.phaseStarted(bruteForceSolverPhaseScope);
    }

    public void stepTaken(BruteForceStepScope bruteForceStepScope) {
        super.stepTaken(bruteForceStepScope);
        this.bruteForceEntityWalker.stepTaken(bruteForceStepScope);
        BruteForceSolverPhaseScope bruteForceSolverPhaseScope = bruteForceStepScope.getBruteForceSolverPhaseScope();
        this.logger.debug("Step index ({}), time spend ({}), score ({}), {} best score ({}).", new Object[]{bruteForceStepScope.getStepIndex(), bruteForceSolverPhaseScope.calculateSolverTimeMillisSpend(), bruteForceStepScope.getScore(), bruteForceStepScope.getBestScoreImproved() != false ? "new" : "   ", bruteForceSolverPhaseScope.getBestScore()});
    }

    public void phaseEnded(BruteForceSolverPhaseScope bruteForceSolverPhaseScope) {
        super.phaseEnded(bruteForceSolverPhaseScope);
        this.bruteForceEntityWalker.phaseEnded(bruteForceSolverPhaseScope);
        this.logger.info("Brute force phase ended at step index ({}) for best score ({}).", (Object)bruteForceSolverPhaseScope.getLastCompletedStepScope().getStepIndex(), (Object)bruteForceSolverPhaseScope.getBestScore());
    }
}

