/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.domain.entity;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.drools.planner.api.domain.entity.PlanningEntity;
import org.drools.planner.api.domain.entity.PlanningEntityDifficultyWeightFactory;
import org.drools.planner.api.domain.variable.PlanningVariable;
import org.drools.planner.core.domain.entity.PlanningEntitySorter;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanningEntityDescriptor {
    private final SolutionDescriptor solutionDescriptor;
    private final Class<?> planningEntityClass;
    private final BeanInfo planningEntityBeanInfo;
    private PlanningEntitySorter planningEntitySorter;
    private Map<String, PlanningVariableDescriptor> planningVariableDescriptorMap;

    public PlanningEntityDescriptor(SolutionDescriptor solutionDescriptor, Class<?> planningEntityClass) {
        this.solutionDescriptor = solutionDescriptor;
        this.planningEntityClass = planningEntityClass;
        try {
            this.planningEntityBeanInfo = Introspector.getBeanInfo(planningEntityClass);
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException("The planningEntityClass (" + planningEntityClass + ") is not a valid java bean.", e);
        }
        this.processEntityAnnotations();
        this.processPropertyAnnotations();
    }

    private void processEntityAnnotations() {
        Class<? extends PlanningEntityDifficultyWeightFactory> difficultyWeightFactoryClass;
        PlanningEntity planningEntityAnnotation = this.planningEntityClass.getAnnotation(PlanningEntity.class);
        if (planningEntityAnnotation == null) {
            throw new IllegalStateException("The planningEntityClass (" + this.planningEntityClass + ") has been specified as a planning entity in the configuration," + " but does not have a PlanningEntity annotation.");
        }
        Class<? extends Comparator> difficultyComparatorClass = planningEntityAnnotation.difficultyComparatorClass();
        if (difficultyComparatorClass == PlanningEntity.NullDifficultyComparator.class) {
            difficultyComparatorClass = null;
        }
        if ((difficultyWeightFactoryClass = planningEntityAnnotation.difficultyWeightFactoryClass()) == PlanningEntity.NullDifficultyWeightFactory.class) {
            difficultyWeightFactoryClass = null;
        }
        if (difficultyComparatorClass != null && difficultyWeightFactoryClass != null) {
            throw new IllegalStateException("The planningEntityClass (" + this.planningEntityClass + ") cannot have a difficultyComparatorClass (" + difficultyComparatorClass.getName() + ") and a difficultyWeightFactoryClass (" + difficultyWeightFactoryClass.getName() + ") at the same time.");
        }
        this.planningEntitySorter = new PlanningEntitySorter();
        if (difficultyComparatorClass != null) {
            Comparator difficultyComparator;
            try {
                difficultyComparator = difficultyComparatorClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("The difficultyComparatorClass (" + difficultyComparatorClass.getName() + ") does not have a public no-arg constructor", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("The difficultyComparatorClass (" + difficultyComparatorClass.getName() + ") does not have a public no-arg constructor", e);
            }
            this.planningEntitySorter.setDifficultyComparator(difficultyComparator);
        }
        if (difficultyWeightFactoryClass != null) {
            PlanningEntityDifficultyWeightFactory difficultyWeightFactory;
            try {
                difficultyWeightFactory = difficultyWeightFactoryClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("The difficultyWeightFactoryClass (" + difficultyWeightFactoryClass.getName() + ") does not have a public no-arg constructor", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("The difficultyWeightFactoryClass (" + difficultyWeightFactoryClass.getName() + ") does not have a public no-arg constructor", e);
            }
            this.planningEntitySorter.setDifficultyWeightFactory(difficultyWeightFactory);
        }
    }

    private void processPropertyAnnotations() {
        int mapSize = this.planningEntityBeanInfo.getPropertyDescriptors().length;
        this.planningVariableDescriptorMap = new HashMap<String, PlanningVariableDescriptor>(mapSize);
        boolean noPlanningVariableAnnotation = true;
        for (PropertyDescriptor propertyDescriptor : this.planningEntityBeanInfo.getPropertyDescriptors()) {
            Method propertyGetter = propertyDescriptor.getReadMethod();
            if (!propertyGetter.isAnnotationPresent(PlanningVariable.class)) continue;
            noPlanningVariableAnnotation = false;
            if (propertyDescriptor.getWriteMethod() == null) {
                throw new IllegalStateException("The planningEntityClass (" + this.planningEntityClass + ") has a PlanningVariable annotated property (" + propertyDescriptor.getName() + ") that should have a setter.");
            }
            PlanningVariableDescriptor planningVariableDescriptor = new PlanningVariableDescriptor(this, propertyDescriptor);
            this.planningVariableDescriptorMap.put(propertyDescriptor.getName(), planningVariableDescriptor);
        }
        if (noPlanningVariableAnnotation) {
            throw new IllegalStateException("The planningEntityClass (" + this.planningEntityClass + ") should have at least 1 getter with a PlanningVariable annotation.");
        }
    }

    public SolutionDescriptor getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    public Class<?> getPlanningEntityClass() {
        return this.planningEntityClass;
    }

    public PlanningEntitySorter getPlanningEntitySorter() {
        return this.planningEntitySorter;
    }

    public Collection<PlanningVariableDescriptor> getPlanningVariableDescriptors() {
        return this.planningVariableDescriptorMap.values();
    }

    public boolean isInitialized(Object planningEntity) {
        for (PlanningVariableDescriptor planningVariableDescriptor : this.planningVariableDescriptorMap.values()) {
            if (planningVariableDescriptor.isInitialized(planningEntity)) continue;
            return false;
        }
        return true;
    }

    public void uninitialize(Object planningEntity) {
        for (PlanningVariableDescriptor planningVariableDescriptor : this.planningVariableDescriptorMap.values()) {
            planningVariableDescriptor.uninitialize(planningEntity);
        }
    }
}

