/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.domain.solution;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.planner.api.domain.solution.PlanningEntityCollectionProperty;
import org.drools.planner.api.domain.solution.PlanningEntityProperty;
import org.drools.planner.core.domain.common.DescriptorUtils;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.solution.Solution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolutionDescriptor
implements Serializable {
    private final Class<? extends Solution> solutionClass;
    private final BeanInfo solutionBeanInfo;
    private final Map<String, PropertyDescriptor> propertyDescriptorMap;
    private final Map<String, PropertyDescriptor> entityPropertyDescriptorMap;
    private final Map<String, PropertyDescriptor> entityCollectionPropertyDescriptorMap;
    private final Map<Class<?>, PlanningEntityDescriptor> planningEntityDescriptorMap;

    public SolutionDescriptor(Class<? extends Solution> solutionClass) {
        this.solutionClass = solutionClass;
        try {
            this.solutionBeanInfo = Introspector.getBeanInfo(solutionClass);
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException("The solutionClass (" + solutionClass + ") is not a valid java bean.", e);
        }
        int mapSize = this.solutionBeanInfo.getPropertyDescriptors().length;
        this.propertyDescriptorMap = new HashMap<String, PropertyDescriptor>(mapSize);
        this.entityPropertyDescriptorMap = new HashMap<String, PropertyDescriptor>(mapSize);
        this.entityCollectionPropertyDescriptorMap = new HashMap<String, PropertyDescriptor>(mapSize);
        this.planningEntityDescriptorMap = new HashMap(mapSize);
        this.processPropertyAnnotations();
    }

    private void processPropertyAnnotations() {
        boolean noPlanningEntityPropertyAnnotation = true;
        for (PropertyDescriptor propertyDescriptor : this.solutionBeanInfo.getPropertyDescriptors()) {
            this.propertyDescriptorMap.put(propertyDescriptor.getName(), propertyDescriptor);
            Method propertyGetter = propertyDescriptor.getReadMethod();
            if (propertyGetter.isAnnotationPresent(PlanningEntityProperty.class)) {
                noPlanningEntityPropertyAnnotation = false;
                this.entityPropertyDescriptorMap.put(propertyDescriptor.getName(), propertyDescriptor);
                continue;
            }
            if (!propertyGetter.isAnnotationPresent(PlanningEntityCollectionProperty.class)) continue;
            noPlanningEntityPropertyAnnotation = false;
            if (!Collection.class.isAssignableFrom(propertyDescriptor.getPropertyType())) {
                throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") has a PlanningEntityCollection annotated property (" + propertyDescriptor.getName() + ") that does not return a Collection.");
            }
            this.entityCollectionPropertyDescriptorMap.put(propertyDescriptor.getName(), propertyDescriptor);
        }
        if (noPlanningEntityPropertyAnnotation) {
            throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") should have at least 1 getter with a PlanningEntityCollection or PlanningEntityProperty" + " annotation.");
        }
    }

    public Class<? extends Solution> getSolutionClass() {
        return this.solutionClass;
    }

    public PropertyDescriptor getPropertyDescriptor(String propertyName) {
        return this.propertyDescriptorMap.get(propertyName);
    }

    public void addPlanningEntityDescriptor(PlanningEntityDescriptor planningEntityDescriptor) {
        this.planningEntityDescriptorMap.put(planningEntityDescriptor.getPlanningEntityClass(), planningEntityDescriptor);
    }

    public Set<Class<?>> getPlanningEntityImplementationClassSet() {
        return this.planningEntityDescriptorMap.keySet();
    }

    public PlanningEntityDescriptor getPlanningEntityDescriptor(Class<?> planningEntityImplementationClass) {
        PlanningEntityDescriptor planningEntityDescriptor = null;
        for (Class<?> planningEntityClass = planningEntityImplementationClass; planningEntityClass != null; planningEntityClass = planningEntityClass.getSuperclass()) {
            planningEntityDescriptor = this.planningEntityDescriptorMap.get(planningEntityClass);
            if (planningEntityDescriptor == null) continue;
            return planningEntityDescriptor;
        }
        return null;
    }

    public Collection<Object> getAllFacts(Solution solution) {
        ArrayList<Object> planningFacts = new ArrayList<Object>();
        planningFacts.addAll(solution.getProblemFacts());
        for (PropertyDescriptor entityPropertyDescriptor : this.entityPropertyDescriptorMap.values()) {
            Object entity = this.extractPlanningEntity(entityPropertyDescriptor, solution);
            PlanningEntityDescriptor planningEntityDescriptor = this.getPlanningEntityDescriptor(entity.getClass());
            if (entity == null || !planningEntityDescriptor.isInitialized(entity)) continue;
            planningFacts.add(entity);
        }
        for (PropertyDescriptor entityCollectionPropertyDescriptor : this.entityCollectionPropertyDescriptorMap.values()) {
            Collection<?> entityCollection = this.extractPlanningEntityCollection(entityCollectionPropertyDescriptor, solution);
            for (Object entity : entityCollection) {
                PlanningEntityDescriptor planningEntityDescriptor = this.getPlanningEntityDescriptor(entity.getClass());
                if (!planningEntityDescriptor.isInitialized(entity)) continue;
                planningFacts.add(entity);
            }
        }
        return planningFacts;
    }

    public List<Object> getPlanningEntityList(Solution solution) {
        ArrayList<Object> planningEntityList = new ArrayList<Object>();
        for (PropertyDescriptor entityPropertyDescriptor : this.entityPropertyDescriptorMap.values()) {
            Object entity = this.extractPlanningEntity(entityPropertyDescriptor, solution);
            if (entity == null) continue;
            planningEntityList.add(entity);
        }
        for (PropertyDescriptor entityCollectionPropertyDescriptor : this.entityCollectionPropertyDescriptorMap.values()) {
            Collection<?> entityCollection = this.extractPlanningEntityCollection(entityCollectionPropertyDescriptor, solution);
            planningEntityList.addAll(entityCollection);
        }
        return planningEntityList;
    }

    public boolean isInitialized(Solution solution) {
        for (PropertyDescriptor entityPropertyDescriptor : this.entityPropertyDescriptorMap.values()) {
            Object entity = this.extractPlanningEntity(entityPropertyDescriptor, solution);
            PlanningEntityDescriptor planningEntityDescriptor = this.getPlanningEntityDescriptor(entity.getClass());
            if (entity != null && planningEntityDescriptor.isInitialized(entity)) continue;
            return false;
        }
        for (PropertyDescriptor entityCollectionPropertyDescriptor : this.entityCollectionPropertyDescriptorMap.values()) {
            Collection<?> entityCollection = this.extractPlanningEntityCollection(entityCollectionPropertyDescriptor, solution);
            for (Object entity : entityCollection) {
                PlanningEntityDescriptor planningEntityDescriptor = this.getPlanningEntityDescriptor(entity.getClass());
                if (planningEntityDescriptor.isInitialized(entity)) continue;
                return false;
            }
        }
        return true;
    }

    private Object extractPlanningEntity(PropertyDescriptor entityPropertyDescriptor, Solution solution) {
        return DescriptorUtils.executeGetter(entityPropertyDescriptor, solution);
    }

    private Collection<?> extractPlanningEntityCollection(PropertyDescriptor entityCollectionPropertyDescriptor, Solution solution) {
        Collection entityCollection = (Collection)DescriptorUtils.executeGetter(entityCollectionPropertyDescriptor, solution);
        if (entityCollection == null) {
            throw new IllegalArgumentException("The solutionClass (" + this.solutionClass + ")'s entityCollectionProperty (" + entityCollectionPropertyDescriptor.getName() + ") should never return null.");
        }
        return entityCollection;
    }
}

