/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.domain.variable;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.drools.planner.api.domain.variable.PlanningValueStrengthWeightFactory;
import org.drools.planner.api.domain.variable.PlanningVariable;
import org.drools.planner.api.domain.variable.ValueRangeFromSolutionProperty;
import org.drools.planner.api.domain.variable.ValueRangeUndefined;
import org.drools.planner.core.domain.common.DescriptorUtils;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.domain.variable.PlanningValueSorter;
import org.drools.planner.core.solution.Solution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanningVariableDescriptor {
    private final PlanningEntityDescriptor planningEntityDescriptor;
    private final PropertyDescriptor variablePropertyDescriptor;
    private PropertyDescriptor rangePropertyDescriptor;
    private PlanningValueSorter planningValueSorter;

    public PlanningVariableDescriptor(PlanningEntityDescriptor planningEntityDescriptor, PropertyDescriptor variablePropertyDescriptor) {
        this.planningEntityDescriptor = planningEntityDescriptor;
        this.variablePropertyDescriptor = variablePropertyDescriptor;
        this.processPropertyAnnotations();
    }

    private void processPropertyAnnotations() {
        Method propertyGetter;
        Class<? extends PlanningValueStrengthWeightFactory> strengthWeightFactoryClass;
        PlanningVariable planningVariableAnnotation = this.variablePropertyDescriptor.getReadMethod().getAnnotation(PlanningVariable.class);
        Class<? extends Comparator> strengthComparatorClass = planningVariableAnnotation.strengthComparatorClass();
        if (strengthComparatorClass == PlanningVariable.NullStrengthComparator.class) {
            strengthComparatorClass = null;
        }
        if ((strengthWeightFactoryClass = planningVariableAnnotation.strengthWeightFactoryClass()) == PlanningVariable.NullStrengthWeightFactory.class) {
            strengthWeightFactoryClass = null;
        }
        if (strengthComparatorClass != null && strengthWeightFactoryClass != null) {
            throw new IllegalStateException("The planningEntityClass (" + this.planningEntityDescriptor.getPlanningEntityClass() + ") " + this.variablePropertyDescriptor.getName() + ") cannot have a strengthComparatorClass (" + strengthComparatorClass.getName() + ") and a strengthWeightFactoryClass (" + strengthWeightFactoryClass.getName() + ") at the same time.");
        }
        this.planningValueSorter = new PlanningValueSorter();
        if (strengthComparatorClass != null) {
            Comparator strengthComparator;
            try {
                strengthComparator = strengthComparatorClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("The strengthComparatorClass (" + strengthComparatorClass.getName() + ") does not have a public no-arg constructor", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("The strengthComparatorClass (" + strengthComparatorClass.getName() + ") does not have a public no-arg constructor", e);
            }
            this.planningValueSorter.setStrengthComparator(strengthComparator);
        }
        if (strengthWeightFactoryClass != null) {
            PlanningValueStrengthWeightFactory strengthWeightFactory;
            try {
                strengthWeightFactory = strengthWeightFactoryClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("The strengthWeightFactoryClass (" + strengthWeightFactoryClass.getName() + ") does not have a public no-arg constructor", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("The strengthWeightFactoryClass (" + strengthWeightFactoryClass.getName() + ") does not have a public no-arg constructor", e);
            }
            this.planningValueSorter.setStrengthWeightFactory(strengthWeightFactory);
        }
        if ((propertyGetter = this.variablePropertyDescriptor.getReadMethod()).isAnnotationPresent(ValueRangeFromSolutionProperty.class)) {
            this.processValueRangeSolutionPropertyAnnotation(propertyGetter.getAnnotation(ValueRangeFromSolutionProperty.class));
        } else if (propertyGetter.isAnnotationPresent(ValueRangeUndefined.class)) {
            this.processValueRangeUndefinedAnnotation(propertyGetter.getAnnotation(ValueRangeUndefined.class));
        } else {
            throw new IllegalArgumentException("The planningEntityClass (" + this.planningEntityDescriptor.getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variablePropertyDescriptor.getName() + ") that has no ValueRange* annotation, such as ValueRangeFromSolutionProperty.");
        }
    }

    private void processValueRangeSolutionPropertyAnnotation(ValueRangeFromSolutionProperty valueRangeFromSolutionPropertyAnnotation) {
        String solutionPropertyName = valueRangeFromSolutionPropertyAnnotation.propertyName();
        this.rangePropertyDescriptor = this.planningEntityDescriptor.getSolutionDescriptor().getPropertyDescriptor(solutionPropertyName);
        if (this.rangePropertyDescriptor == null) {
            String exceptionMessage = "The planningEntityClass (" + this.planningEntityDescriptor.getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variablePropertyDescriptor.getName() + ") that refers to a solutionClass (" + this.planningEntityDescriptor.getSolutionDescriptor().getSolutionClass() + ") solutionProperty (" + solutionPropertyName + ") that does not exist.";
            if (solutionPropertyName.length() >= 2 && Character.isUpperCase(solutionPropertyName.charAt(1))) {
                String correctedSolutionPropertyName = solutionPropertyName.substring(0, 1).toUpperCase() + solutionPropertyName.substring(1);
                exceptionMessage = exceptionMessage + " But it probably needs to be correctedSolutionPropertyName (" + correctedSolutionPropertyName + ") instead because the JavaBeans spec states" + " the first letter should be a upper case if the second is upper case.";
            }
            throw new IllegalArgumentException(exceptionMessage);
        }
        if (!Collection.class.isAssignableFrom(this.rangePropertyDescriptor.getPropertyType())) {
            throw new IllegalArgumentException("The planningEntityClass (" + this.planningEntityDescriptor.getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variablePropertyDescriptor.getName() + ") that refers to a solutionClass (" + this.planningEntityDescriptor.getSolutionDescriptor().getSolutionClass() + ") solutionProperty (" + solutionPropertyName + ") that does not return a Collection.");
        }
    }

    private void processValueRangeUndefinedAnnotation(ValueRangeUndefined valueRangeUndefined) {
        this.rangePropertyDescriptor = null;
    }

    public PlanningEntityDescriptor getPlanningEntityDescriptor() {
        return this.planningEntityDescriptor;
    }

    public String getVariablePropertyName() {
        return this.variablePropertyDescriptor.getName();
    }

    public PlanningValueSorter getPlanningValueSorter() {
        return this.planningValueSorter;
    }

    public boolean isInitialized(Object planningEntity) {
        Object variable = DescriptorUtils.executeGetter(this.variablePropertyDescriptor, planningEntity);
        return variable != null;
    }

    public void uninitialize(Object planningEntity) {
        DescriptorUtils.executeSetter(this.variablePropertyDescriptor, planningEntity, null);
    }

    public Object getValue(Object bean) {
        return DescriptorUtils.executeGetter(this.variablePropertyDescriptor, bean);
    }

    public void setValue(Object bean, Object value) {
        DescriptorUtils.executeSetter(this.variablePropertyDescriptor, bean, value);
    }

    private Collection<?> extractPlanningValueCollection(Solution solution) {
        if (this.rangePropertyDescriptor == null) {
            throw new IllegalStateException("The planningEntityClass (" + this.planningEntityDescriptor.getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variablePropertyDescriptor.getName() + ") which uses a @ValueRangeUndefined instead of a @ValueRangeFromSolutionProperty.");
        }
        return (Collection)DescriptorUtils.executeGetter(this.rangePropertyDescriptor, solution);
    }

    public List<Object> getPlanningValueList(Solution solution) {
        return new ArrayList<Object>(this.extractPlanningValueCollection(solution));
    }
}

