/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.variable;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.drools.planner.core.domain.variable.PlanningValueSorter;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.heuristic.selector.variable.PlanningValueSelectionOrder;
import org.drools.planner.core.heuristic.selector.variable.PlanningValueSelectionPromotion;
import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.phase.event.SolverPhaseLifecycleListenerAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanningValueSelector
extends SolverPhaseLifecycleListenerAdapter
implements Iterable<Object> {
    private PlanningVariableDescriptor planningVariableDescriptor;
    private PlanningValueSelectionOrder selectionOrder = PlanningValueSelectionOrder.ORIGINAL;
    private PlanningValueSelectionPromotion selectionPromotion = PlanningValueSelectionPromotion.NONE;
    private boolean roundRobinSelection = false;
    private List<Object> selectedPlanningValueList = null;

    public PlanningValueSelector(PlanningVariableDescriptor planningVariableDescriptor) {
        this.planningVariableDescriptor = planningVariableDescriptor;
    }

    public void setSelectionOrder(PlanningValueSelectionOrder selectionOrder) {
        this.selectionOrder = selectionOrder;
    }

    public void setSelectionPromotion(PlanningValueSelectionPromotion selectionPromotion) {
        this.selectionPromotion = selectionPromotion;
    }

    public void setRoundRobinSelection(boolean roundRobinSelection) {
        this.roundRobinSelection = roundRobinSelection;
    }

    @Override
    public void phaseStarted(AbstractSolverPhaseScope solverPhaseScope) {
        this.validateConfiguration();
        this.initSelectedPlanningValueList(solverPhaseScope);
    }

    private void validateConfiguration() {
        PlanningValueSorter planningValueSorter;
        if (this.selectionOrder == PlanningValueSelectionOrder.INCREASING_STRENGTH && !(planningValueSorter = this.planningVariableDescriptor.getPlanningValueSorter()).isSortStrengthSupported()) {
            throw new IllegalStateException("The selectionOrder (" + (Object)((Object)this.selectionOrder) + ") can not be used on PlanningEntity (" + this.planningVariableDescriptor.getPlanningEntityDescriptor().getPlanningEntityClass().getName() + ")'s planningVariable (" + this.planningVariableDescriptor.getVariablePropertyName() + ") that has no support for strength sorting. Check the @PlanningVariable annotation.");
        }
    }

    private void initSelectedPlanningValueList(AbstractSolverPhaseScope solverPhaseScope) {
        List<Object> workingPlanningValueList = this.planningVariableDescriptor.getPlanningValueList(solverPhaseScope.getWorkingSolution());
        switch (this.selectionOrder) {
            case ORIGINAL: {
                break;
            }
            case RANDOM: {
                Collections.shuffle(workingPlanningValueList, solverPhaseScope.getWorkingRandom());
                break;
            }
            case INCREASING_STRENGTH: {
                PlanningValueSorter planningValueSorter = this.planningVariableDescriptor.getPlanningValueSorter();
                planningValueSorter.sortStrengthAscending(solverPhaseScope.getWorkingSolution(), workingPlanningValueList);
                break;
            }
            default: {
                throw new IllegalStateException("The selectionOrder (" + (Object)((Object)this.selectionOrder) + ") is not implemented");
            }
        }
        this.selectedPlanningValueList = workingPlanningValueList;
    }

    @Override
    public void phaseEnded(AbstractSolverPhaseScope solverPhaseScope) {
        this.selectedPlanningValueList = null;
    }

    @Override
    public Iterator<Object> iterator() {
        return this.selectedPlanningValueList.iterator();
    }
}

