/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.ReentrantLock;
import org.drools.core.util.Queue;
import org.drools.core.util.Queueable;
import org.drools.spi.Activation;

public class BinaryHeapQueue
implements Queue,
Externalizable {
    private static final int DEFAULT_CAPACITY = 13;
    private Comparator comparator;
    private int size;
    private Queueable[] elements;
    private ReentrantLock lock;

    public BinaryHeapQueue() {
    }

    public BinaryHeapQueue(Comparator comparator) {
        this(comparator, 13);
    }

    public BinaryHeapQueue(Comparator comparator, int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("invalid capacity");
        }
        this.elements = new Queueable[capacity + 1];
        this.comparator = comparator;
        this.lock = new ReentrantLock();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.comparator = (Comparator)in.readObject();
        this.elements = (Queueable[])in.readObject();
        this.size = in.readInt();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.comparator);
        out.writeObject(this.elements);
        out.writeInt(this.size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            this.lock.lock();
            this.elements = new Queueable[this.elements.length];
            this.size = 0;
            Object var2_1 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Activation[] getAndClear() {
        try {
            this.lock.lock();
            Activation[] queue = this.elements;
            this.elements = new Queueable[this.elements.length];
            this.size = 0;
            Activation[] activationArray = queue;
            Object var4_3 = null;
            this.lock.unlock();
            return activationArray;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isFull() {
        return this.elements.length == this.size + 1;
    }

    public int size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Queueable element) {
        try {
            this.lock.lock();
            if (this.isFull()) {
                this.grow();
            }
            this.percolateUpMaxHeap(element);
            Object var3_2 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queueable dequeue() throws NoSuchElementException {
        block3: {
            try {
                this.lock.lock();
                if (!this.isEmpty()) break block3;
                Queueable queueable = null;
                Object var4_3 = null;
                this.lock.unlock();
                return queueable;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.lock.unlock();
                throw throwable;
            }
        }
        Queueable result = this.elements[1];
        result.dequeue();
        Queueable queueable = result;
        Object var4_4 = null;
        this.lock.unlock();
        return queueable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queueable dequeue(int index) {
        block7: {
            try {
                this.lock.lock();
                if (index >= 1 && index <= this.size) break block7;
                Queueable queueable = null;
                Object var5_4 = null;
                this.lock.unlock();
                return queueable;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.lock.unlock();
                throw throwable;
            }
        }
        Queueable result = this.elements[index];
        this.setElement(index, this.elements[this.size]);
        this.elements[this.size] = null;
        --this.size;
        if (this.size != 0 && index <= this.size) {
            int compareToParent = 0;
            if (index > 1) {
                compareToParent = this.compare(this.elements[index], this.elements[index / 2]);
            }
            if (index > 1 && compareToParent > 0) {
                this.percolateUpMaxHeap(index);
            } else {
                this.percolateDownMaxHeap(index);
            }
        }
        Queueable queueable = result;
        Object var5_5 = null;
        this.lock.unlock();
        return queueable;
    }

    protected void percolateDownMaxHeap(int index) {
        Queueable element = this.elements[index];
        int hole = index;
        while (hole * 2 <= this.size) {
            int child = hole * 2;
            if (child != this.size && this.compare(this.elements[child + 1], this.elements[child]) > 0) {
                ++child;
            }
            if (this.compare(this.elements[child], element) <= 0) break;
            this.setElement(hole, this.elements[child]);
            hole = child;
        }
        this.setElement(hole, element);
    }

    protected void percolateUpMaxHeap(int index) {
        int hole = index;
        Queueable element = this.elements[hole];
        while (hole > 1 && this.compare(element, this.elements[hole / 2]) > 0) {
            int next = hole / 2;
            this.setElement(hole, this.elements[next]);
            hole = next;
        }
        this.setElement(hole, element);
    }

    protected void percolateUpMaxHeap(Queueable element) {
        this.setElement(++this.size, element);
        this.percolateUpMaxHeap(this.size);
    }

    private int compare(Queueable a, Queueable b) {
        return this.comparator.compare(a, b);
    }

    private void grow() {
        Queueable[] elements = new Queueable[this.elements.length * 2];
        System.arraycopy(this.elements, 0, elements, 0, this.elements.length);
        this.elements = elements;
    }

    private void setElement(int index, Queueable element) {
        this.elements[index] = element;
        element.enqueued(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] a) {
        try {
            this.lock.lock();
            if (a.length < this.size) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
            }
            System.arraycopy(this.elements, 1, a, 0, this.size);
            if (a.length > this.size) {
                a[this.size] = null;
            }
            Object[] objectArray = a;
            Object var4_3 = null;
            this.lock.unlock();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.unlock();
            throw throwable;
        }
    }
}

