/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.descr;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class BaseDescr
implements Externalizable {
    private static final long serialVersionUID = 510L;
    private int startCharacter = -1;
    private int endCharacter = -1;
    private int line = -1;
    private int column = -1;
    private int endLine = -1;
    private int endColumn = -1;
    private String text = "";

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.startCharacter = in.readInt();
        this.endCharacter = in.readInt();
        this.line = in.readInt();
        this.column = in.readInt();
        this.endLine = in.readInt();
        this.endColumn = in.readInt();
        this.text = (String)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.startCharacter);
        out.writeInt(this.endCharacter);
        out.writeInt(this.line);
        out.writeInt(this.column);
        out.writeInt(this.endLine);
        out.writeInt(this.endColumn);
        out.writeObject(this.text);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setLocation(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public void setEndLocation(int line, int column) {
        this.endLine = line;
        this.endColumn = column;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public int getEndCharacter() {
        return this.endCharacter;
    }

    public void setEndCharacter(int endCharacter) {
        this.endCharacter = endCharacter;
    }

    public int getStartCharacter() {
        return this.startCharacter;
    }

    public void setStartCharacter(int startCharacter) {
        this.startCharacter = startCharacter;
    }

    public void copyLocation(BaseDescr d) {
        this.setLocation(d.getLine(), d.getColumn());
        this.setEndLocation(d.getEndLine(), d.getEndColumn());
        this.setStartCharacter(d.getStartCharacter());
        this.setEndCharacter(d.getEndCharacter());
    }
}

