/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.manners2009.solver.solution.initializer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.planner.core.phase.custom.CustomSolverPhaseCommand;
import org.drools.planner.core.score.DefaultSimpleScore;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.SimpleScore;
import org.drools.planner.core.solution.director.SolutionDirector;
import org.drools.planner.examples.common.domain.PersistableIdComparator;
import org.drools.planner.examples.manners2009.domain.Guest;
import org.drools.planner.examples.manners2009.domain.Manners2009;
import org.drools.planner.examples.manners2009.domain.Seat;
import org.drools.planner.examples.manners2009.domain.SeatDesignation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Manners2009StartingSolutionInitializer
implements CustomSolverPhaseCommand {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void changeWorkingSolution(SolutionDirector solutionDirector) {
        Manners2009 manners2009 = (Manners2009)solutionDirector.getWorkingSolution();
        this.initializeSeatDesignationList(solutionDirector, manners2009);
    }

    private void initializeSeatDesignationList(SolutionDirector solutionDirector, Manners2009 manners2009) {
        WorkingMemory workingMemory = solutionDirector.getWorkingMemory();
        List<SeatDesignation> seatDesignationList = this.createSeatDesignationList(manners2009);
        List<Seat> undesignatedSeatList = manners2009.getSeatList();
        for (SeatDesignation seatDesignation : seatDesignationList) {
            Score<SimpleScore> bestScore = DefaultSimpleScore.valueOf(Integer.MIN_VALUE);
            Seat bestSeat = null;
            FactHandle seatDesignationHandle = null;
            for (Seat seat : undesignatedSeatList) {
                Score score;
                if (seatDesignation.getGuest().getGender() != seat.getRequiredGender()) continue;
                seatDesignation.setSeat(seat);
                if (seatDesignationHandle == null) {
                    seatDesignationHandle = workingMemory.insert((Object)seatDesignation);
                } else {
                    workingMemory.update((org.drools.runtime.rule.FactHandle)seatDesignationHandle, (Object)seatDesignation);
                }
                if ((score = solutionDirector.calculateScoreFromWorkingMemory()).compareTo(bestScore) <= 0) continue;
                bestScore = score;
                bestSeat = seat;
            }
            if (bestSeat == null) {
                throw new IllegalStateException("The bestSeat (" + bestSeat + ") cannot be null.");
            }
            seatDesignation.setSeat(bestSeat);
            workingMemory.update(seatDesignationHandle, (Object)seatDesignation);
            undesignatedSeatList.remove(bestSeat);
        }
        Collections.sort(seatDesignationList, new PersistableIdComparator());
        manners2009.setSeatDesignationList(seatDesignationList);
    }

    private List<SeatDesignation> createSeatDesignationList(Manners2009 manners2009) {
        ArrayList<SeatDesignation> seatDesignationList = new ArrayList<SeatDesignation>(manners2009.getGuestList().size());
        for (Guest guest : manners2009.getGuestList()) {
            SeatDesignation seatDesignation = new SeatDesignation();
            seatDesignation.setId(guest.getId());
            seatDesignation.setGuest(guest);
            seatDesignationList.add(seatDesignation);
        }
        return seatDesignationList;
    }
}

