/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.decider.selector;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.drools.planner.core.localsearch.LocalSearchSolverPhaseScope;
import org.drools.planner.core.localsearch.LocalSearchStepScope;
import org.drools.planner.core.localsearch.decider.Decider;
import org.drools.planner.core.localsearch.decider.selector.AbstractSelector;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.move.factory.MoveFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveFactorySelector
extends AbstractSelector {
    protected MoveFactory moveFactory;
    protected boolean shuffle = true;

    public void setMoveFactory(MoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    public void setShuffle(boolean shuffle) {
        this.shuffle = shuffle;
    }

    @Override
    public void setDecider(Decider decider) {
        super.setDecider(decider);
        this.moveFactory.setDecider(decider);
    }

    @Override
    public void phaseStarted(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        this.moveFactory.phaseStarted(localSearchSolverPhaseScope);
    }

    @Override
    public void beforeDeciding(LocalSearchStepScope localSearchStepScope) {
        this.moveFactory.beforeDeciding(localSearchStepScope);
    }

    @Override
    public Iterator<Move> moveIterator(LocalSearchStepScope localSearchStepScope) {
        return this.selectMoveList(localSearchStepScope).iterator();
    }

    public List<Move> selectMoveList(LocalSearchStepScope localSearchStepScope) {
        List<Move> moveList = this.moveFactory.createMoveList(localSearchStepScope.getWorkingSolution());
        if (this.shuffle) {
            Collections.shuffle(moveList, localSearchStepScope.getWorkingRandom());
        }
        return moveList;
    }

    @Override
    public void stepDecided(LocalSearchStepScope localSearchStepScope) {
        this.moveFactory.stepDecided(localSearchStepScope);
    }

    @Override
    public void stepTaken(LocalSearchStepScope localSearchStepScope) {
        this.moveFactory.stepTaken(localSearchStepScope);
    }

    @Override
    public void phaseEnded(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        this.moveFactory.phaseEnded(localSearchSolverPhaseScope);
    }
}

