/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.move;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.drools.WorkingMemory;
import org.drools.planner.core.localsearch.decider.acceptor.tabu.TabuPropertyEnabled;
import org.drools.planner.core.move.Move;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeMove
implements Move,
TabuPropertyEnabled {
    protected List<Move> moveList;

    public List<Move> getMoveList() {
        return this.moveList;
    }

    public CompositeMove(List<Move> moveList) {
        this.moveList = moveList;
    }

    @Override
    public boolean isMoveDoable(WorkingMemory workingMemory) {
        for (Move move : this.moveList) {
            if (move.isMoveDoable(workingMemory)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Move createUndoMove(WorkingMemory workingMemory) {
        ArrayList<Move> undoMoveList = new ArrayList<Move>(this.moveList.size());
        for (Move move : this.moveList) {
            Move undoMove = move.createUndoMove(workingMemory);
            undoMoveList.add(undoMove);
        }
        Collections.reverse(undoMoveList);
        return new CompositeMove(undoMoveList);
    }

    @Override
    public void doMove(WorkingMemory workingMemory) {
        for (Move move : this.moveList) {
            move.doMove(workingMemory);
        }
    }

    @Override
    public Collection<? extends Object> getTabuProperties() {
        LinkedHashSet<? extends Object> tabuProperties = new LinkedHashSet<Object>(this.moveList.size() * 2);
        for (Move move : this.moveList) {
            tabuProperties.addAll(((TabuPropertyEnabled)((Object)move)).getTabuProperties());
        }
        return tabuProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CompositeMove) {
            CompositeMove other = (CompositeMove)o;
            return ((Object)this.moveList).equals(other.moveList);
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.moveList).hashCode();
    }

    public String toString() {
        return this.moveList.toString();
    }
}

